/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfoUnlinked;
import io.github.classgraph.ClassfileBinaryParser;
import io.github.classgraph.ClasspathElementDir;
import io.github.classgraph.ClasspathElementModule;
import io.github.classgraph.ClasspathElementZip;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.Resource;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.WorkQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

abstract class ClasspathElement {
    final ClasspathOrModulePathEntry classpathEltPath;
    List<String> nestedClasspathRootPrefixes;
    boolean skipClasspathElement;
    List<ClasspathOrModulePathEntry> childClasspathElts;
    final ScanSpec scanSpec;
    private final boolean scanFiles;
    protected List<Resource> fileMatches;
    protected List<Resource> classfileMatches;
    protected Map<File, Long> fileToLastModified;

    ClasspathElement(ClasspathOrModulePathEntry classpathEltPath, ScanSpec scanSpec, boolean scanFiles) {
        this.classpathEltPath = classpathEltPath;
        this.scanSpec = scanSpec;
        this.scanFiles = scanFiles;
    }

    public String toString() {
        return this.classpathEltPath.toString();
    }

    File getClasspathElementFile(LogNode log) {
        if (this.classpathEltPath.getModuleRef() != null) {
            return null;
        }
        try {
            return this.classpathEltPath.getFile(log);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    String getJarfilePackageRoot() {
        return this.classpathEltPath.getJarfilePackageRoot();
    }

    ClassLoader[] getClassLoaders() {
        return this.classpathEltPath.getClassLoaders();
    }

    ModuleRef getClasspathElementModuleRef() {
        return this.classpathEltPath.getModuleRef();
    }

    static ClasspathElement newInstance(ClasspathOrModulePathEntry classpathRelativePath, boolean scanFiles, ScanSpec scanSpec, NestedJarHandler nestedJarHandler, WorkQueue<ClasspathOrModulePathEntry> workQueue, LogNode log) {
        ClasspathElement newInstance;
        boolean isModule = false;
        boolean isDir = false;
        String resolvedPath = null;
        File file = null;
        try {
            resolvedPath = classpathRelativePath.getResolvedPath();
            boolean bl = isModule = classpathRelativePath.getModuleRef() != null;
            if (!isModule) {
                file = classpathRelativePath.getFile(log);
                isDir = classpathRelativePath.isDirectory(log);
            }
        }
        catch (IOException e) {
            if (log != null) {
                log.log("Exception while trying to canonicalize path " + classpathRelativePath.getResolvedPath(), e);
            }
            return null;
        }
        LogNode subLog = null;
        if (log != null) {
            String canonicalPath;
            try {
                canonicalPath = isModule ? resolvedPath : classpathRelativePath.getCanonicalPath(log);
            }
            catch (Exception e) {
                canonicalPath = resolvedPath;
            }
            subLog = log.log(resolvedPath, "Scanning " + (isModule ? "module" : (isDir ? "directory" : "jarfile")) + (isModule ? classpathRelativePath.getModuleRef() + (classpathRelativePath.getModuleRef().getLocationStr() == null ? "" : " -> " + classpathRelativePath.getModuleRef().getLocationStr()) : (file.getPath().equals(canonicalPath) ? canonicalPath : classpathRelativePath + " -> " + canonicalPath)));
        }
        ClasspathElement classpathElement = isModule ? new ClasspathElementModule(classpathRelativePath, scanSpec, scanFiles, nestedJarHandler, subLog) : (newInstance = isDir ? new ClasspathElementDir(classpathRelativePath, scanSpec, scanFiles, subLog) : new ClasspathElementZip(classpathRelativePath, scanSpec, scanFiles, nestedJarHandler, workQueue, subLog));
        if (subLog != null) {
            subLog.addElapsedTime();
        }
        return newInstance;
    }

    int getNumClassfileMatches() {
        return this.classfileMatches == null ? 0 : this.classfileMatches.size();
    }

    void maskFiles(int classpathIdx, HashSet<String> classpathRelativePathsFound, LogNode log) {
        if (!this.scanFiles) {
            throw new IllegalArgumentException("scanFiles is false");
        }
        HashSet<String> maskedRelativePaths = new HashSet<String>();
        for (Resource res : this.classfileMatches) {
            String getPathRelativeToPackageRoot = res.getPath();
            if (getPathRelativeToPackageRoot.equals("module-info.class") || getPathRelativeToPackageRoot.endsWith("/module-info.class") || classpathRelativePathsFound.add(getPathRelativeToPackageRoot)) continue;
            maskedRelativePaths.add(getPathRelativeToPackageRoot);
        }
        if (!maskedRelativePaths.isEmpty()) {
            ArrayList<Resource> filteredClassfileMatches = new ArrayList<Resource>();
            for (Resource classfileMatch : this.classfileMatches) {
                String getPathRelativeToPackageRoot = classfileMatch.getPath();
                if (!maskedRelativePaths.contains(getPathRelativeToPackageRoot)) {
                    filteredClassfileMatches.add(classfileMatch);
                    continue;
                }
                if (log == null) continue;
                log.log(String.format("%06d-1", classpathIdx), "Ignoring duplicate (masked) class " + getPathRelativeToPackageRoot.substring(0, getPathRelativeToPackageRoot.length() - 6).replace('/', '.') + " for classpath element " + classfileMatch);
            }
            this.classfileMatches = filteredClassfileMatches;
        }
    }

    void parseClassfiles(int classfileStartIdx, int classfileEndIdx, ConcurrentLinkedQueue<ClassInfoUnlinked> classInfoUnlinked, LogNode log) throws Exception {
        for (int i = classfileStartIdx; i < classfileEndIdx; ++i) {
            try (Resource classfileResource = this.classfileMatches.get(i);){
                LogNode logNode = log == null ? null : log.log(classfileResource.getPath(), "Parsing classfile " + classfileResource);
                ClassInfoUnlinked thisClassInfoUnlinked = new ClassfileBinaryParser().readClassInfoFromClassfileHeader(this, classfileResource.getPath(), classfileResource.openOrRead(), this.scanSpec, logNode);
                if (thisClassInfoUnlinked != null) {
                    classInfoUnlinked.add(thisClassInfoUnlinked);
                    thisClassInfoUnlinked.logTo(logNode);
                }
                if (logNode == null) continue;
                logNode.addElapsedTime();
                continue;
            }
        }
    }

    abstract void scanPaths(LogNode var1);

    abstract void close();
}

