/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.GetSACredentialTest;
import be.iminds.ilabt.jfed.connectivity_tester.GetVersionTest;
import be.iminds.ilabt.jfed.connectivity_tester.HasIPv4AddressTest;
import be.iminds.ilabt.jfed.connectivity_tester.HasIPv6AddressTest;
import be.iminds.ilabt.jfed.connectivity_tester.SslHostAndPortTest;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConnectivityTestFactory {
    private final GeniUserProvider geniUserProvider;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final JavaFXLogger javaFXLogger;
    private final JFedConnectionProvider jFedConnectionProvider;
    private final JFedPreferences jFedPreferences;
    private final AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory;

    @Inject
    public ConnectivityTestFactory(GeniUserProvider geniUserProvider, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, JavaFXLogger javaFXLogger, JFedConnectionProvider jFedConnectionProvider, JFedPreferences jFedPreferences, AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory) {
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.javaFXLogger = javaFXLogger;
        this.jFedConnectionProvider = jFedConnectionProvider;
        this.jFedPreferences = jFedPreferences;
        this.automaticUserAndSliceApiWrapperFactory = automaticUserAndSliceApiWrapperFactory;
    }

    public HasIPv4AddressTest createHasIPv4AddressTest() {
        return new HasIPv4AddressTest();
    }

    public HasIPv6AddressTest createHasIPv6AddressTest() {
        return new HasIPv6AddressTest();
    }

    public SslHostAndPortTest createSslHostAndPortTest(String hostname, int port, String description, String category) {
        return new SslHostAndPortTest(hostname, port, description, category, this.testbedInfoSource);
    }

    public GetSACredentialTest createGetSACredentialTest() {
        return new GetSACredentialTest(this.geniUserProvider, this.jFedConnectionProvider, this.javaFXLogger, this.jFedPreferences, this.automaticUserAndSliceApiWrapperFactory);
    }

    public GetVersionTest createGetVersionTest(String authUrn) {
        return new GetVersionTest(authUrn, this.testbedInfoSource, this.authorityFinder, this.geniUserProvider, this.javaFXLogger, this.jFedConnectionProvider, this.jFedPreferences);
    }

    public GetVersionTest createGetVersionTest(Server auth, JFedConnection.ProxyInfo proxyInfo, int version) {
        return new GetVersionTest(auth, proxyInfo, version, this.geniUserProvider, this.javaFXLogger, this.jFedConnectionProvider, this.jFedPreferences);
    }
}

