/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.HasIPv4AddressTest;
import be.iminds.ilabt.jfed.connectivity_tester.HasIPv6AddressTest;
import be.iminds.ilabt.jfed.connectivity_tester.HostAndPortTest;
import be.iminds.ilabt.jfed.connectivity_tester.Ping6Test;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class Main {
    private static final int POS_HOSTNAME = 0;
    private static final int POS_PORT = 1;
    private static final int POS_DESCRIPTION = 2;
    private static final int POS_CATEGORY = 3;

    public static void main(String[] args) {
        ArrayList<ConnectivityTest> tests = new ArrayList<ConnectivityTest>();
        tests.add(new HasIPv4AddressTest());
        tests.add(new HasIPv6AddressTest());
        tests.add(new Ping6Test());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Main.class.getResourceAsStream("/ports.csv")));){
            String line = reader.readLine();
            assert (line != null);
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(";");
                tests.add(new HostAndPortTest(parts[0], Integer.parseInt(parts[1]), parts[2], parts[3]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ConnectivityTest test : tests) {
            try {
                ConnectivityTest.ConnectivityTestResult result = (ConnectivityTest.ConnectivityTestResult)test.call();
                System.out.println(test.getName() + " status: " + String.valueOf((Object)result.getStatus()));
                if (result.getMessage() != null) {
                    System.out.println(test.getName() + " message: " + result.getMessage());
                }
                if (result.getException() == null) continue;
                System.out.println(test.getName() + " exception: " + String.valueOf(result.getException()));
            }
            catch (Exception e) {
                System.out.println(test.getName() + " threw an exception: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

