/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SfaExperimentPart
extends ExperimentPart {
    private final Server connectAuthority;
    private final Server componentManagerAuthority;
    private final boolean acceptTopAuthSlivers;
    private final boolean acceptSubAuthSliver;
    private final boolean acceptConnectAuth;
    private final ObservableList<Sliver> slivers = FXCollections.observableArrayList();
    private final ObjectProperty<RenewStatus> renewStatus = new SimpleObjectProperty(null);
    private InvalidationListener listenerThatUpdatesExpirationTime = observable -> this.updateExpirationTime();

    public SfaExperimentPart(Experiment experiment, Server connectAuthority, Server componentManagerAuthority) {
        super(experiment);
        this.connectAuthority = connectAuthority;
        this.componentManagerAuthority = componentManagerAuthority;
        this.acceptTopAuthSlivers = false;
        this.acceptSubAuthSliver = !connectAuthority.hasFlag(Server.Flag.centralBrokerArchitectureBrokerauth);
        this.acceptConnectAuth = connectAuthority.hasFlag(Server.Flag.centralBrokerArchitectureBrokerauth);
        assert (experiment.getSliceOrNull() != null);
        this.slivers.addListener(c -> {
            while (c.next()) {
                for (Sliver sliver : c.getAddedSubList()) {
                    sliver.expirationDateProperty().addListener(this.listenerThatUpdatesExpirationTime);
                }
                for (Sliver sliver : c.getRemoved()) {
                    sliver.expirationDateProperty().removeListener(this.listenerThatUpdatesExpirationTime);
                }
            }
            Runnable r = this::updateExpirationTime;
            if (Platform.isFxApplicationThread()) {
                r.run();
            } else {
                Platform.runLater((Runnable)r);
            }
        });
        experiment.getSlice().getObservableSlivers().addListener(c -> {
            while (c.next()) {
                this.slivers.addAll((Collection)c.getAddedSubList().stream().filter(this::doesSliverBelongToThis).collect(Collectors.toList()));
                c.getRemoved().forEach(arg_0 -> this.slivers.remove(arg_0));
            }
        });
        this.slivers.addAll(experiment.getSlice().findSlivers(componentManagerAuthority));
    }

    private boolean doesSliverBelongToThis(Sliver sliver) {
        GeniUrn sliverUrn = sliver.getServer().getDefaultComponentManagerAsGeniUrn();
        if (this.acceptConnectAuth && Objects.equals(sliverUrn.getEncodedTopLevelAuthority_withoutSubAuth(), this.componentManagerAuthority.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth())) {
            return true;
        }
        if (!sliverUrn.hasCompatibleAuthority(this.componentManagerAuthority.getDefaultComponentManagerAsGeniUrn())) {
            return false;
        }
        if (this.acceptTopAuthSlivers && this.acceptSubAuthSliver) {
            return true;
        }
        if (this.acceptTopAuthSlivers) {
            return sliverUrn.getSubAuthCount() <= this.componentManagerAuthority.getDefaultComponentManagerAsGeniUrn().getSubAuthCount();
        }
        if (this.acceptSubAuthSliver) {
            return sliverUrn.getSubAuthCount() >= this.componentManagerAuthority.getDefaultComponentManagerAsGeniUrn().getSubAuthCount();
        }
        return Objects.equals(sliverUrn.getEncodedTopLevelAuthority(), this.componentManagerAuthority.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority());
    }

    @Override
    public String getName() {
        return this.getConnectSfaAuthority().getName();
    }

    public Server getComponentManagerSfaAuthority() {
        return this.componentManagerAuthority;
    }

    public Server getConnectSfaAuthority() {
        return this.connectAuthority;
    }

    private void updateExpirationTime() {
        this.expirationTime.set((Object)this.slivers.stream().filter(sliver -> !sliver.isFake()).map(Sliver::getExpirationDate).filter(Objects::nonNull).min(Comparator.naturalOrder()).orElse(this.experiment.getSlice().getExpirationDate()));
    }

    @Nonnull
    public Collection<Sliver> getSlivers() {
        assert (this.experiment.getSliceOrNull() != null);
        return this.experiment.getSlice().findSlivers(this.getConnectSfaAuthority());
    }

    public StatusDetails getStatusDetails() {
        boolean hasStatus = false;
        StatusDetails statusDetails = new StatusDetails(StatusDetails.SliverStatus.READY);
        for (Sliver sliver : this.getSlivers()) {
            if (sliver.getStatus() == null) continue;
            statusDetails.add(sliver.getStatus());
            hasStatus = true;
        }
        if (hasStatus) {
            return statusDetails;
        }
        return new StatusDetails(StatusDetails.SliverStatus.UNKNOWN);
    }

    @Nullable
    public RenewStatus getRenewStatus() {
        return (RenewStatus)this.renewStatus.get();
    }

    public ObjectProperty<RenewStatus> renewStatusProperty() {
        return this.renewStatus;
    }

    public void setRenewStatus(@Nullable RenewStatus renewStatus) {
        this.renewStatus.set((Object)renewStatus);
    }

    public static class RenewStatus {
        @Nonnull
        private final ExperimentTaskStatus status;
        private final boolean refused;
        @Nonnull
        private final String message;

        public RenewStatus(@Nonnull ExperimentTaskStatus status, boolean refused, @Nonnull String message) {
            this.status = status;
            this.refused = refused;
            this.message = message;
        }

        @Nonnull
        public ExperimentTaskStatus getStatus() {
            return this.status;
        }

        public boolean isRefused() {
            return this.refused;
        }

        @Nonnull
        public String getMessage() {
            return this.message;
        }

        public String toString() {
            return "RenewStatus{status=" + String.valueOf((Object)this.status) + ", refused=" + this.refused + ", message='" + this.message + "'}";
        }
    }
}

