/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class GenerateSimpleRequestRSpec
extends RequestRSpec {
    private final int nodeCount;
    @Nonnull
    private final String nodeSliverType;
    private final boolean nodeExclusive;
    @Nonnull
    private final List<String> nodeComponentUrn;
    @Nonnull
    private final List<String> nodeAnsibleGroup;

    public GenerateSimpleRequestRSpec() {
        super(RequestRSpec.RequestRSpecSource.GENERATE_SIMPLE, false, false);
        this.nodeCount = 1;
        this.nodeSliverType = "raw-pc";
        this.nodeExclusive = true;
        this.nodeComponentUrn = Collections.emptyList();
        this.nodeAnsibleGroup = Collections.emptyList();
    }

    @JsonCreator
    public GenerateSimpleRequestRSpec(@Nonnull @JsonProperty(value="source") RequestRSpec.RequestRSpecSource source, @Nullable @JsonProperty(value="nodeCount") Integer nodeCount, @Nullable @JsonProperty(value="nodeSliverType") String nodeSliverType, @Nullable @JsonProperty(value="nodeExclusive") Boolean nodeExclusive, @Nullable @JsonProperty(value="nodeComponentUrn") List<String> nodeComponentUrn, @Nullable @JsonProperty(value="nodeAnsibleGroup") List<String> nodeAnsibleGroup, @Nullable @JsonProperty(value="autoAssignSpecificNodesUsingListResources") Boolean autoAssignSpecificNodesUsingListResources, @Nullable @JsonProperty(value="useNitosLease") Boolean useNitosLease) {
        super(source, autoAssignSpecificNodesUsingListResources, useNitosLease);
        assert (source == RequestRSpec.RequestRSpecSource.GENERATE_SIMPLE);
        assert (this.getSource() == RequestRSpec.RequestRSpecSource.GENERATE_SIMPLE);
        this.nodeCount = nodeCount == null ? new GenerateSimpleRequestRSpec().getNodeCount() : nodeCount.intValue();
        this.nodeSliverType = nodeSliverType == null ? new GenerateSimpleRequestRSpec().getNodeSliverType() : nodeSliverType;
        this.nodeExclusive = nodeExclusive == null ? new GenerateSimpleRequestRSpec().getNodeExclusive() : nodeExclusive.booleanValue();
        this.nodeComponentUrn = nodeComponentUrn == null ? new GenerateSimpleRequestRSpec().getNodeComponentUrn() : nodeComponentUrn;
        this.nodeAnsibleGroup = nodeAnsibleGroup == null ? new GenerateSimpleRequestRSpec().getNodeAnsibleGroup() : nodeAnsibleGroup;
    }

    @Override
    @JsonIgnore
    public boolean isValid() {
        if (this.nodeCount <= 0) {
            throw new IllegalArgumentException("Config Error: rspec.nodeCount == " + this.nodeCount + " makes no sense if rspec.source == " + String.valueOf((Object)this.source));
        }
        return true;
    }

    @JsonProperty
    public int getNodeCount() {
        return this.nodeCount;
    }

    @JsonProperty
    @Nonnull
    public String getNodeSliverType() {
        return this.nodeSliverType;
    }

    @JsonProperty
    public boolean getNodeExclusive() {
        return this.nodeExclusive;
    }

    @JsonProperty
    @Nonnull
    public List<String> getNodeComponentUrn() {
        return this.nodeComponentUrn;
    }

    @JsonProperty
    @Nonnull
    public List<String> getNodeAnsibleGroup() {
        return this.nodeAnsibleGroup;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateSimpleRequestRSpec)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenerateSimpleRequestRSpec that = (GenerateSimpleRequestRSpec)o;
        if (this.nodeCount != that.nodeCount) {
            return false;
        }
        if (this.nodeExclusive != that.nodeExclusive) {
            return false;
        }
        if (!this.nodeSliverType.equals(that.nodeSliverType)) {
            return false;
        }
        if (!this.nodeAnsibleGroup.equals(that.nodeAnsibleGroup)) {
            return false;
        }
        return this.nodeComponentUrn.equals(that.nodeComponentUrn);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.nodeCount;
        result = 31 * result + this.nodeSliverType.hashCode();
        result = 31 * result + (this.nodeExclusive ? 1 : 0);
        result = 31 * result + this.nodeComponentUrn.hashCode();
        result = 31 * result + this.nodeAnsibleGroup.hashCode();
        return result;
    }
}

