/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment.setup.config;

import be.iminds.ilabt.jfed.experiment.setup.config.AlreadyProvisionedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateSimpleRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingAdvertisementRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.GenerateUsingJFedRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedContentRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedFileRequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.ProvidedUrlRequestRSpec;
import be.iminds.ilabt.jfed.rspec.adv_based_generator.AdvertisementBasedRspecGeneratorConfig;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="source", defaultImpl=GenerateUsingJFedRequestRSpec.class, visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=GenerateSimpleRequestRSpec.class, name="GENERATE_SIMPLE"), @JsonSubTypes.Type(value=ProvidedUrlRequestRSpec.class, name="PROVIDE_URL"), @JsonSubTypes.Type(value=ProvidedFileRequestRSpec.class, name="PROVIDE_FILE"), @JsonSubTypes.Type(value=ProvidedContentRequestRSpec.class, name="PROVIDE_CONTENT"), @JsonSubTypes.Type(value=GenerateUsingJFedRequestRSpec.class, name="GENERATE_USING_JFED"), @JsonSubTypes.Type(value=GenerateUsingAdvertisementRequestRSpec.class, name="GENERATE_USING_ADVERTISEMENT"), @JsonSubTypes.Type(value=AlreadyProvisionedRequestRSpec.class, name="ALREADY_PROVISIONED")})
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public abstract class RequestRSpec {
    private static final Logger LOG = LoggerFactory.getLogger(RequestRSpec.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    @Nonnull
    protected final RequestRSpecSource source;
    private final boolean autoAssignSpecificNodesUsingListResources;
    private final boolean useNitosLease;

    @JsonCreator
    public RequestRSpec(@Nonnull @JsonProperty(value="source") RequestRSpecSource source, @Nullable @JsonProperty(value="autoAssignSpecificNodesUsingListResources") Boolean autoAssignSpecificNodesUsingListResources, @Nullable @JsonProperty(value="useNitosLease") Boolean useNitosLease) {
        assert (source != null);
        this.source = source;
        this.autoAssignSpecificNodesUsingListResources = autoAssignSpecificNodesUsingListResources == null ? RequestRSpec.getDefault().getAutoAssignSpecificNodesUsingListResources() : autoAssignSpecificNodesUsingListResources.booleanValue();
        this.useNitosLease = useNitosLease == null ? RequestRSpec.getDefault().getUseNitosLease() : useNitosLease.booleanValue();
    }

    public static RequestRSpec getDefault() {
        return new GenerateUsingJFedRequestRSpec();
    }

    @JsonCreator
    public static RequestRSpec createRequestRSpecFromJsonObject(@Nonnull Map<String, Object> props) {
        RequestRSpecSource source = props.get("source") == null ? null : RequestRSpecSource.valueOf((String)props.get("source"));
        Boolean autoAssignSpecificNodesUsingListResources = (Boolean)props.get("autoAssignSpecificNodesUsingListResources");
        Boolean useNitosLease = (Boolean)props.get("useNitosLease");
        LOG.debug("createRequestRSpecFromJsonObject with source=" + String.valueOf((Object)source));
        if (source == null) {
            LOG.debug("createRequestRSpecFromJsonObject with source=null -> reverting all to defaults");
            return RequestRSpec.getDefault();
        }
        switch (source.ordinal()) {
            case 6: {
                return new AlreadyProvisionedRequestRSpec(source, autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
            case 1: {
                return new ProvidedFileRequestRSpec(source, (String)props.get("providedContentSource"), (Boolean)props.get("bindTestedServerToUnboundNodes"), (String)props.get("bindUnboundNodesUrn"), autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
            case 0: {
                return new ProvidedUrlRequestRSpec(source, (String)props.get("providedContentSource"), (Boolean)props.get("bindTestedServerToUnboundNodes"), (String)props.get("bindUnboundNodesUrn"), autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
            case 2: {
                return new ProvidedContentRequestRSpec(source, (String)props.get("providedContentSource"), (Boolean)props.get("bindTestedServerToUnboundNodes"), (String)props.get("bindUnboundNodesUrn"), autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
            case 5: {
                AdvertisementBasedRspecGeneratorConfig advertisementBasedRspecGeneratorConfig = (AdvertisementBasedRspecGeneratorConfig)MAPPER.convertValue(props.get("config"), AdvertisementBasedRspecGeneratorConfig.class);
                return new GenerateUsingAdvertisementRequestRSpec(source, autoAssignSpecificNodesUsingListResources, useNitosLease, advertisementBasedRspecGeneratorConfig);
            }
            case 4: {
                return new GenerateSimpleRequestRSpec(source, (Integer)props.get("nodeCount"), (String)props.get("nodeSliverType"), (Boolean)props.get("nodeExclusive"), (List)props.get("nodeComponentUrn"), (List)props.get("nodeAnsibleGroup"), autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
            case 3: {
                return new GenerateUsingJFedRequestRSpec(source, (Integer)props.get("nodeCount"), (String)props.get("jFedResourceClass"), (List)props.get("nodeAnsibleGroup"), autoAssignSpecificNodesUsingListResources, useNitosLease);
            }
        }
        throw new IllegalArgumentException("Config Error: unsupported rspec.source == " + String.valueOf((Object)source));
    }

    @JsonIgnore
    public abstract boolean isValid();

    @JsonProperty
    @Nonnull
    public RequestRSpecSource getSource() {
        return this.source;
    }

    @JsonProperty
    public boolean getAutoAssignSpecificNodesUsingListResources() {
        return this.autoAssignSpecificNodesUsingListResources;
    }

    @JsonProperty
    public boolean getUseNitosLease() {
        return this.useNitosLease;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RequestRSpec)) {
            return false;
        }
        RequestRSpec that = (RequestRSpec)o;
        if (this.autoAssignSpecificNodesUsingListResources != that.autoAssignSpecificNodesUsingListResources) {
            return false;
        }
        if (this.useNitosLease != that.useNitosLease) {
            return false;
        }
        return this.source == that.source;
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + (this.autoAssignSpecificNodesUsingListResources ? 1 : 0);
        result = 31 * result + (this.useNitosLease ? 1 : 0);
        return result;
    }

    public static enum RequestRSpecSource {
        PROVIDE_URL,
        PROVIDE_FILE,
        PROVIDE_CONTENT,
        GENERATE_USING_JFED,
        GENERATE_SIMPLE,
        GENERATE_USING_ADVERTISEMENT,
        ALREADY_PROVISIONED;


        public boolean isProvide() {
            return this == PROVIDE_URL || this == PROVIDE_FILE || this == PROVIDE_CONTENT;
        }
    }
}

