/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.call_log_output;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsWriter;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReport;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportConstants;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class CallReportWriter {
    private static final Logger LOG = LoggerFactory.getLogger(CallReportWriter.class);
    private final ApiCallDetailsCache cache;

    @Inject
    public CallReportWriter(ApiCallDetailsCache cache) {
        this.cache = cache;
    }

    public synchronized void writeCallReport(CallReport callReport, XMLEventWriter xtw, XMLEventFactory eventFactory, boolean useCallRefs) throws XMLStreamException {
        QName topLevelElement = CallReportConstants.Q_CALL_REPORT;
        xtw.add(eventFactory.createStartElement(topLevelElement, null, null));
        xtw.add(eventFactory.createAttribute(CallReportConstants.Q_TITLE, callReport.getReportTitle()));
        xtw.add(eventFactory.createAttribute(CallReportConstants.Q_REPORTER, callReport.getReportObject()));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_STATES, null, null));
        for (CallReport.State state : callReport.getStates()) {
            this.writeState(state, xtw, eventFactory, useCallRefs);
        }
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_STATES, null));
        xtw.add(eventFactory.createEndElement(topLevelElement, null));
        xtw.flush();
    }

    private void writeState(CallReport.State state, XMLEventWriter xtw, XMLEventFactory eventFactory, boolean useCallRefs) throws XMLStreamException {
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_STATE, null, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_START, null, null));
        xtw.add(eventFactory.createCharacters(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(state.getStateStart().toInstant(), ZoneId.systemDefault()))));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_START, null));
        if (state.getEnd() != null) {
            xtw.add(eventFactory.createStartElement(CallReportConstants.Q_END, null, null));
            xtw.add(eventFactory.createCharacters(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.ofInstant(state.getEnd().toInstant(), ZoneId.systemDefault()))));
            xtw.add(eventFactory.createEndElement(CallReportConstants.Q_END, null));
        }
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_NAME, null, null));
        xtw.add(eventFactory.createCharacters(state.getName()));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_NAME, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_LOGENTRIES, null, null));
        for (LogOutput.LogEntry logLine : state.getLogLines()) {
            this.writeLogLine(logLine, xtw, eventFactory);
        }
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_LOGENTRIES, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_CALLS, null, null));
        for (ApiCallDetailsRef apiCallDetailsRef : state.getCalls()) {
            if (useCallRefs) {
                this.writeApiCallDetailsRef(apiCallDetailsRef, xtw, eventFactory);
            } else {
                SerializableApiCallDetails apiCallDetails = this.cache.getApiCallDetails(apiCallDetailsRef);
                if (apiCallDetails != null) {
                    SerializableApiCallDetailsWriter.writeApiCallDetails((SerializableApiCallDetails)apiCallDetails, (XMLEventWriter)xtw, (XMLEventFactory)eventFactory);
                }
            }
            xtw.flush();
        }
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_CALLS, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_STATESTATE, null, null));
        xtw.add(eventFactory.createCharacters(state.getState().name()));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_STATESTATE, null));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_STATE, null));
        xtw.flush();
    }

    private void writeLogLine(LogOutput.LogEntry logLine, XMLEventWriter xtw, XMLEventFactory eventFactory) throws XMLStreamException {
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_LOGENTRY, null, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_TYPE, null, null));
        xtw.add(eventFactory.createCharacters(logLine.getType().name()));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_TYPE, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_TEXT, null, null));
        xtw.add(eventFactory.createCharacters(logLine.getText()));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_TEXT, null));
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_TIME_IN_MS, null, null));
        xtw.add(eventFactory.createCharacters(Long.toString(logLine.getTimeMs())));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_TIME_IN_MS, null));
        if (logLine.getExceptionStackTrace() != null) {
            xtw.add(eventFactory.createStartElement(CallReportConstants.Q_EXCEPTION, null, null));
            xtw.add(eventFactory.createCharacters(logLine.getExceptionStackTrace()));
            xtw.add(eventFactory.createEndElement(CallReportConstants.Q_EXCEPTION, null));
        }
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_LOGENTRY, null));
    }

    public void writeApiCallDetailsRef(ApiCallDetailsRef apiCallDetailsRef, XMLEventWriter xtw, XMLEventFactory eventFactory) throws XMLStreamException {
        xtw.add(eventFactory.createStartElement(CallReportConstants.Q_CALL_REF, null, null));
        xtw.add(eventFactory.createAttribute(CallReportConstants.Q_CALL_REF_ID, Integer.toString(apiCallDetailsRef.getId())));
        xtw.add(eventFactory.createEndElement(CallReportConstants.Q_CALL_REF, null));
    }

    public synchronized void writeCallReport(CallReport callReport, File file, boolean useCallRefs) throws FileNotFoundException, XMLStreamException {
        FileOutputStream fos = new FileOutputStream(file);
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        this.writeCallReport(callReport, xof.createXMLEventWriter(fos), XMLEventFactory.newInstance(), useCallRefs);
    }

    public synchronized String writeCallReportToString(CallReport callReport, boolean useCallRefs) throws XMLStreamException {
        StringWriter sw = new StringWriter();
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        this.writeCallReport(callReport, xof.createXMLEventWriter(sw), XMLEventFactory.newInstance(), useCallRefs);
        return sw.toString();
    }
}

