/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.controller;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.util.MappedList;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class JavaFXTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(JavaFXTaskThread.class);
    private final TaskThread real;
    private final ApiCallDetailsCache apiCallDetailsCache;
    private final ObservableList<Task> tasks = FXCollections.observableArrayList();
    private final ObservableList<FXTaskExecution> FXTaskExecutions = FXCollections.observableArrayList();
    private final ObservableList<FutureTask> futureTasks = FXCollections.observableArrayList();
    private final ReadOnlyIntegerWrapper callsCount = new ReadOnlyIntegerWrapper(0);
    private final ReadOnlyIntegerWrapper unfinishedCallsCount = new ReadOnlyIntegerWrapper(0);
    private final BooleanExpression busy = this.unfinishedCallsCount.greaterThan(0);
    private int taskdebug_helper_PreviousRealAllTasksSize = -1;

    @Inject
    JavaFXTaskThread(TaskThread real, ApiCallDetailsCache apiCallDetailsCache) {
        this.real = real;
        this.apiCallDetailsCache = apiCallDetailsCache;
        Thread updateThread = new Thread(() -> {
            while (!this.real.isStopRequested()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                JavaFXTaskThread javaFXTaskThread = this;
                synchronized (javaFXTaskThread) {
                    Platform.runLater(() -> {
                        JavaFXTaskThread javaFXTaskThread = this;
                        synchronized (javaFXTaskThread) {
                            this.update();
                            this.notifyAll();
                        }
                    });
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Interrupted while waiting for JavaFXTaskThread update", (Throwable)e);
                    }
                }
            }
        });
        updateThread.setDaemon(true);
        updateThread.setName("JavaFXTaskThread");
        LOG.debug("Starting JavaFXTaskThread periodic updates");
        updateThread.start();
    }

    private static <T> void syncList(List<T> orig, ObservableList<T> target) {
        boolean changed = false;
        if (orig.size() == target.size()) {
            for (int i = 0; i < orig.size(); ++i) {
                if (orig.get(i) == target.get(i)) continue;
                changed = true;
                break;
            }
        } else {
            changed = true;
        }
        if (changed) {
            target.setAll(orig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        int unfinishedCount = 0;
        if (LOG.isDebugEnabled() && this.taskdebug_helper_PreviousRealAllTasksSize != this.real.allTasks.size()) {
            LOG.debug("JavaFXTaskThread periodic update: real.allTasks.size()==" + this.real.allTasks.size());
        }
        List<TaskExecution> list = this.real.allTasks;
        synchronized (list) {
            for (TaskExecution taskExecution : this.real.allTasks) {
                Object task = taskExecution.task;
                TaskExecution.TaskState state = taskExecution.getState();
                if (state == TaskExecution.TaskState.QUEUED || state == TaskExecution.TaskState.RUNNING) {
                    ++unfinishedCount;
                }
                if (((be.iminds.ilabt.jfed.highlevel.controller.Task)task).javafx == null) {
                    ((be.iminds.ilabt.jfed.highlevel.controller.Task)task).javafx = new Task((be.iminds.ilabt.jfed.highlevel.controller.Task)task);
                    this.tasks.add((Object)((be.iminds.ilabt.jfed.highlevel.controller.Task)task).javafx);
                }
                for (TaskThread.FutureTask futureTask : ((be.iminds.ilabt.jfed.highlevel.controller.Task)task).futureTasks) {
                    if (futureTask.javafx != null) continue;
                    futureTask.javafx = new FutureTask(futureTask);
                    this.futureTasks.add((Object)futureTask.javafx);
                }
                if (taskExecution.javafx != null) continue;
                taskExecution.javafx = new FXTaskExecution(taskExecution, taskExecution.getName(), taskExecution.getId());
                this.FXTaskExecutions.add((Object)taskExecution.javafx);
            }
        }
        this.unfinishedCallsCount.set(unfinishedCount);
        if (LOG.isDebugEnabled() && this.taskdebug_helper_PreviousRealAllTasksSize != this.real.allTasks.size()) {
            LOG.debug("JavaFXTaskThread periodic update:                                                     tasks.size()==" + this.tasks.size() + "  FXTaskExecutions.size()==" + this.FXTaskExecutions.size() + "  futureTasks.size()==" + this.futureTasks.size());
        }
        this.taskdebug_helper_PreviousRealAllTasksSize = this.real.allTasks.size();
        for (Task task : this.tasks) {
            task.update();
        }
        for (FXTaskExecution st : this.FXTaskExecutions) {
            st.update();
        }
        for (FutureTask ft : this.futureTasks) {
            ft.update();
        }
    }

    public void cancel(FXTaskExecution task) {
        this.real.cancel(task.real);
    }

    public ReadOnlyIntegerProperty unfinishedCallsCountProperty() {
        return this.unfinishedCallsCount.getReadOnlyProperty();
    }

    public BooleanExpression busyProperty() {
        return this.busy;
    }

    public ObservableList<FXTaskExecution> getAllTasks() {
        return this.FXTaskExecutions;
    }

    public int getCallsCount() {
        return this.callsCount.get();
    }

    public ReadOnlyIntegerProperty callsCountProperty() {
        return this.callsCount.getReadOnlyProperty();
    }

    public void clear() {
        ArrayList<FXTaskExecution> toRemove = new ArrayList<FXTaskExecution>();
        for (FXTaskExecution fxTaskExecution : this.getAllTasks()) {
            fxTaskExecution.clearCallsCache();
            if (fxTaskExecution.getState() != TaskExecution.TaskState.SUCCESS && fxTaskExecution.getState() != TaskExecution.TaskState.FAILED && fxTaskExecution.getState() != TaskExecution.TaskState.CANCELLED) continue;
            toRemove.add(fxTaskExecution);
        }
        this.FXTaskExecutions.removeAll(toRemove);
    }

    public class Task {
        private final be.iminds.ilabt.jfed.highlevel.controller.Task real;
        private final ObservableList<FutureTask> futures = FXCollections.observableArrayList();
        private final ObservableList<FXTaskExecution> currentActiveFXTaskExecutions = FXCollections.observableArrayList();

        public Task(be.iminds.ilabt.jfed.highlevel.controller.Task real) {
            this.real = real;
        }

        public void update() {
            ArrayList<FXTaskExecution> newCurrentActiveFXTaskExecutions = new ArrayList<FXTaskExecution>();
            for (TaskExecution st : this.real.getCurrentActiveTaskExecutionsCopy()) {
                if (st.javafx == null) continue;
                newCurrentActiveFXTaskExecutions.add(st.javafx);
            }
            JavaFXTaskThread.syncList(newCurrentActiveFXTaskExecutions, this.currentActiveFXTaskExecutions);
            ArrayList<FutureTask> newFutures = new ArrayList<FutureTask>();
            for (TaskThread.FutureTask ft : this.real.getFuturesCopy()) {
                if (ft.javafx == null) continue;
                newFutures.add(ft.javafx);
            }
            JavaFXTaskThread.syncList(newFutures, this.futures);
        }

        public ObservableList<FXTaskExecution> getCurrentActiveFXTaskExecutions() {
            return this.currentActiveFXTaskExecutions;
        }

        public ObservableList<FutureTask> getFutures() {
            return this.futures;
        }
    }

    public class FutureTask {
        private final TaskThread.FutureTask real;
        private final LongProperty timeLeftMs = new SimpleLongProperty();

        public FutureTask(TaskThread.FutureTask real) {
            this.real = real;
        }

        public void update() {
            this.timeLeftMs.set(this.real.getTimeLeftMs());
        }

        public ObservableLongValue getTimeLeftMs() {
            return this.timeLeftMs;
        }
    }

    public class FXTaskExecution {
        private final TaskExecution<?> real;
        private final String name;
        private final String id;
        private final ObjectProperty<TaskExecution.TaskState> state = new SimpleObjectProperty();
        private final ObservableList<FXTaskExecution> observableDependsOn = FXCollections.observableArrayList();
        private final ObservableList<FXTaskExecution> observableDependingOnThis = FXCollections.observableArrayList();
        private final ObservableList<ApiCallDetailsRef> apiCallHistory = FXCollections.observableArrayList();
        private final ObjectProperty<Date> runStart = new SimpleObjectProperty();
        private final ObjectProperty<Date> runStop = new SimpleObjectProperty();
        private final BooleanProperty cancelled = new SimpleBooleanProperty(false);
        private final ObjectProperty<Throwable> exception = new SimpleObjectProperty();

        public FXTaskExecution(TaskExecution<?> real, String name, String id) {
            this.real = real;
            this.name = name;
            this.id = id;
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update() {
            TaskExecution<?> taskExecution = this.real;
            synchronized (taskExecution) {
                this.state.set((Object)this.real.getState());
                if (this.real.getApiCallHistory().size() != this.apiCallHistory.size()) {
                    JavaFXTaskThread.this.callsCount.set(JavaFXTaskThread.this.callsCount.get() + this.real.getApiCallHistory().size() - this.apiCallHistory.size());
                }
                JavaFXTaskThread.syncList(this.real.getApiCallHistory(), this.apiCallHistory);
                this.runStart.set((Object)this.real.getRunStart());
                this.runStop.set((Object)this.real.getRunStop());
                this.cancelled.set(this.real.isCanceledByUser());
                this.exception.set((Object)this.real.getException());
                ArrayList<FXTaskExecution> newDeps = new ArrayList<FXTaskExecution>();
                for (TaskExecution<?> dep : this.real.getDependsOn()) {
                    if (dep.javafx == null) continue;
                    newDeps.add(dep.javafx);
                }
                JavaFXTaskThread.syncList(newDeps, this.observableDependsOn);
                ArrayList<FXTaskExecution> newDepOn = new ArrayList<FXTaskExecution>();
                for (TaskExecution<?> dep : this.real.getDependingOnThis()) {
                    if (dep.javafx == null) continue;
                    newDepOn.add(dep.javafx);
                }
                JavaFXTaskThread.syncList(newDepOn, this.observableDependingOnThis);
            }
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }

        public ObjectProperty<TaskExecution.TaskState> stateProperty() {
            return this.state;
        }

        public TaskExecution.TaskState getState() {
            return (TaskExecution.TaskState)((Object)this.state.get());
        }

        public ObjectProperty<Date> runStartDateProperty() {
            return this.runStart;
        }

        public ObjectProperty<Date> runStopDateProperty() {
            return this.runStop;
        }

        public ObservableList<FXTaskExecution> getObservableDependsOn() {
            return this.observableDependsOn;
        }

        public ObservableList<FXTaskExecution> getObservableDependingOnThis() {
            return this.observableDependingOnThis;
        }

        public ObservableList<SerializableApiCallDetails> getApiCallHistory() {
            return new MappedList<SerializableApiCallDetails, ApiCallDetailsRef>(this.apiCallHistory, JavaFXTaskThread.this.apiCallDetailsCache::getApiCallDetails);
        }

        public ObservableValue<Boolean> completedProperty() {
            return this.state.isEqualTo((Object)TaskExecution.TaskState.FAILED).or((ObservableBooleanValue)this.state.isEqualTo((Object)TaskExecution.TaskState.SUCCESS));
        }

        public ObservableValue<Boolean> cancelledByUserProperty() {
            return this.cancelled;
        }

        public ObjectProperty<Throwable> getException() {
            return this.exception;
        }

        private void clearCallsCache() {
            int oldCallsCount = this.apiCallHistory.size();
            this.apiCallHistory.clear();
            JavaFXTaskThread.this.callsCount.set(JavaFXTaskThread.this.callsCount.get() - oldCallsCount);
        }
    }
}

