/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.controller;

import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecutionFinishedCallback;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskExecution<T extends Task>
implements ResultListener {
    private static final AtomicInteger taskUniqueIdHelper = new AtomicInteger();
    protected final T task;
    protected final String name;
    protected final String id;
    protected final List<ApiCallDetailsRef> apiCallHistory = new CopyOnWriteArrayList<ApiCallDetailsRef>();
    private final ApiCallDetailsCache cache;
    private final List<TaskExecution<?>> dependsOn = new CopyOnWriteArrayList();
    private final List<TaskExecution<?>> dependingOnThis = new CopyOnWriteArrayList();
    private final Collection<TaskExecutionFinishedCallback<T>> callbacks;
    protected TaskState state;
    protected Throwable exception = null;
    protected JavaFXTaskThread.FXTaskExecution javafx;
    private boolean canceledByUser = false;
    private ZonedDateTime runStart;
    private ZonedDateTime runStop;
    private Thread thread;

    public TaskExecution(T task, Collection<TaskExecutionFinishedCallback<T>> callbacks, ApiCallDetailsCache cache) {
        this.task = task;
        this.cache = cache;
        this.name = ((Task)task).getName();
        this.id = "" + taskUniqueIdHelper.getAndIncrement();
        this.callbacks = callbacks;
        this.state = TaskState.UNSUBMITTED;
    }

    public TaskExecution(T task, ApiCallDetailsCache cache) {
        this(task, Collections.emptyList(), cache);
    }

    Thread getThread() {
        return this.thread;
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    public List<TaskExecution<?>> getDependsOn() {
        return this.dependsOn;
    }

    public List<TaskExecution<?>> getDependingOnThis() {
        return this.dependingOnThis;
    }

    public void onResult(ApiCallDetails result) {
        this.apiCallHistory.add(this.cache.registerApiCallDetails(result));
    }

    public List<ApiCallDetailsRef> getApiCallHistory() {
        return this.apiCallHistory;
    }

    public boolean isCanceledByUser() {
        return this.canceledByUser;
    }

    void setCanceledByUser(boolean canceledByUser) {
        this.canceledByUser = canceledByUser;
    }

    public Date getRunStart() {
        return this.runStart != null ? Date.from(this.runStart.toInstant()) : null;
    }

    public Date getRunStop() {
        return this.runStop != null ? Date.from(this.runStop.toInstant()) : null;
    }

    public TaskState getState() {
        return this.state;
    }

    public void setState(TaskState newState) {
        this.state = newState;
    }

    public T getTask() {
        return this.task;
    }

    public boolean isCompleted() {
        return Objects.equals((Object)this.state, (Object)TaskState.FAILED) || Objects.equals((Object)this.state, (Object)TaskState.SUCCESS) || Objects.equals((Object)this.state, (Object)TaskState.CANCELLED);
    }

    void registerRunStart() {
        assert (this.runStart == null);
        this.runStart = ZonedDateTime.now();
    }

    void registerRunStop() {
        assert (this.runStop == null);
        this.runStop = ZonedDateTime.now();
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        Object deps = "";
        for (TaskExecution<?> dep : this.dependsOn) {
            if (!((String)deps).isEmpty()) {
                deps = (String)deps + ", ";
            }
            deps = (String)deps + "\"" + dep.name + "\" " + String.valueOf((Object)dep.state);
        }
        return "TaskExecution(" + this.id + " \"" + this.getName() + "\" " + String.valueOf((Object)this.state) + ", deps={" + (String)deps + "})";
    }

    public JavaFXTaskThread.FXTaskExecution getFXTaskExecution() {
        return this.javafx;
    }

    public Collection<TaskExecutionFinishedCallback<T>> getTaskExecutionFinishedCallbacks() {
        return this.callbacks;
    }

    public static enum TaskState {
        UNSUBMITTED,
        BLOCKED,
        QUEUED,
        RUNNING,
        FAILED,
        FUTURE,
        SUCCESS,
        CANCELLED;

    }
}

