/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.AllocationDirector;
import be.iminds.ilabt.jfed.highlevel.jobs.BasicAllocationDirector;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSliceThread;
import be.iminds.ilabt.jfed.highlevel.jobs.StitchingAllocationDirector;
import be.iminds.ilabt.jfed.highlevel.jobs.UnknownAuthorityException;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.NonSfaExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.report.StitchingJobReport;
import be.iminds.ilabt.jfed.highlevel.jobs.states.AllocateSliversOnAuthorityState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.CreateUserSpecListState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.states.StopExperimentAtAuthorityPartState;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.GetAdvertisementTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.SCSRequestTask;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.StitchingComputationService;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.stitching.StitchingDirector;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocateExperimentJob
extends AbstractJob<Boolean> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(AllocateExperimentJob.class);
    @Nonnull
    private final LogEntryGeneratorWrappingLogger log;
    private static final int TIME_BETWEEN_ALLOCATE_RETRIES_MS = 10000;
    private static final int MAX_ALLOCATE_STITCH_ACTION_TRIES = 3;
    private Integer waitForReadyDelay = null;
    @Nullable
    private final Server scsAuthority;
    private final JobStateFactory jobStateFactory;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final ExperimentPartControllerManager epcManager;
    @Nonnull
    private final StitchingJobReport stitchingJobReport;
    @Nonnull
    private final LogEntryGeneratorWrappingLogger stitchingDirectorLog;
    @Nonnull
    private final AllocationDirector allocationDirector;
    private Boolean success = null;
    private Collection<GeniUrn> failedResources = null;

    public AllocateExperimentJob(Experiment experiment, @Nullable Server scsAuthority, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, ExperimentPartControllerManager epcManager) {
        super(j -> new StitchingJobReport((AllocateExperimentJob)j), "Allocate Experiment " + experiment.getName(), experiment, hltf, tt);
        this.scsAuthority = scsAuthority;
        this.jobStateFactory = jobStateFactory;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.epcManager = epcManager;
        assert (experiment.getRequestedEndTime() != null);
        this.stitchingJobReport = (StitchingJobReport)this.getJobReport();
        this.log = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, this.getJobReport());
        this.stitchingDirectorLog = new LogEntryGeneratorWrappingLogger(StitchingDirector.ACTUAL_LOG, this.getJobReport());
        this.allocationDirector = experiment.getNewRequestRspecSource() != null && experiment.getNewRequestRspecSource().getStringRspec() != null && Objects.equals(experiment.getNewRequestRspecSource().getStringRspec().isStitching(testbedInfoSource, authorityFinder), Boolean.TRUE) ? new StitchingAllocationDirector(experiment, testbedInfoSource, authorityFinder, this.stitchingDirectorLog) : new BasicAllocationDirector(experiment);
    }

    @Override
    public Boolean execute() throws Exception {
        assert (this.experiment.getNewRequestRspecSource() != null);
        CreateUserSpecListState createUserSpecListState = this.jobStateFactory.createCreateUserSpecListState(this.experiment);
        this.setAndRunState(createUserSpecListState);
        this.experiment.updateUserSpecs(createUserSpecListState.getUserSpecs());
        this.log.debug("AllocateExperimentJob started");
        assert (this.experiment.getSliceOrNull() != null);
        assert (this.experiment.getRequestedEndTime() != null);
        Slice slice = this.experiment.getSliceOrNull();
        if (slice == null) {
            throw new IllegalStateException("There is no slice in which to allocate");
        }
        if (this.experiment.getRequestedEndTime() == null) {
            throw new IllegalStateException("There is no end time for allocation");
        }
        if (this.allocationDirector instanceof StitchingAllocationDirector) {
            this.log.debug("AllocateExperimentJob prepares stitching");
            SCSRequestState scsRequestState = new SCSRequestState();
            this.setAndRunState(scsRequestState);
            if (scsRequestState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                this.log.error("SCS call failed", scsRequestState.getTaskExecution().getException());
                this.success = false;
                return false;
            }
            StitchingComputationService.ComputePathResult result = ((SCSRequestTask)scsRequestState.getTask()).getResult();
            assert (result != null);
            if (result == null) {
                throw new IllegalStateException("Did not receive result from SCSRequestState Task: Stitching setup failed.");
            }
            slice.setRequestRspec((RequestRspecSource)new ImmutableRequestRspecSource(result.getServiceRspec(), ModelRspecType.FX));
            ((StitchingAllocationDirector)this.allocationDirector).setComputePathResult(result);
            this.log.debug("AllocateExperimentJob prepared stitching");
        }
        this.setAndRunState(new PopulateExperimentPartsState());
        if (this.experiment.isPartsEmpty()) {
            this.log.warn("AllocateExperimentJob experiment has NO parts");
        } else {
            this.log.debug("AllocateExperimentJob experiment has " + this.experiment.getPartsSize() + " parts");
        }
        if (this.hasNonSfaParts()) {
            this.log.debug("AllocateExperimentJob starting non SFA parts");
            this.setAndRunState(new CreateNonSfaExperimentPartsContainersState());
            this.setAndRunState(new StartNonSfaPartsState());
        }
        if (!this.hasSfaParts()) {
            this.log.debug("AllocateExperimentJob succesfull without SFA parts");
            return true;
        }
        AllocateSfaPartsState allocateSfaPartsState = new AllocateSfaPartsState();
        this.setAndRunState(allocateSfaPartsState);
        if (allocateSfaPartsState.isPermanentFailure()) {
            this.log.info("AllocatePartsState reported permanent failure");
            this.log.debug("AllocateExperimentJob stopped in failure");
            this.success = false;
            return false;
        }
        this.log.debug("AllocateExperimentJob stopped successfully");
        this.success = true;
        return true;
    }

    public Boolean isSuccess() {
        return this.success;
    }

    @Nonnull
    public StitchingJobReport getStitchingJobReport() {
        return this.stitchingJobReport;
    }

    public Collection<GeniUrn> getFailedResources() {
        return this.failedResources;
    }

    private Collection<SfaExperimentPart> getSfaParts() {
        return this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(SfaExperimentPart.class::cast).collect(Collectors.toList());
    }

    private Collection<NonSfaExperimentPartController> getNonSfaExperimentPartControllers() {
        HashSet<NonSfaExperimentPartController> controllers = new HashSet<NonSfaExperimentPartController>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (experimentPart instanceof SfaExperimentPart) continue;
            ExperimentPartController epc = this.epcManager.getController(experimentPart);
            if (!(epc instanceof NonSfaExperimentPartController)) {
                throw new RuntimeException("Expected a non-sfa ExperimentPartController");
            }
            controllers.add((NonSfaExperimentPartController)epc);
        }
        return controllers;
    }

    private boolean hasNonSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> !(part instanceof SfaExperimentPart));
    }

    private boolean hasSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> part instanceof SfaExperimentPart);
    }

    public class SCSRequestState
    extends SingleCallState<SCSRequestTask> {
        protected SCSRequestState() {
            super("Request stitched link setup-instructions", AllocateExperimentJob.this.hltf.createSCSRequestTask(AllocateExperimentJob.this.experiment.getSlice(), AllocateExperimentJob.this.experiment.getNewRequestRspecSource(), AllocateExperimentJob.this.experiment.getRequestedEndTime(), AllocateExperimentJob.this.scsAuthority));
        }

        @Override
        @Nonnull
        public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
            super.executeState(job);
            return ((SCSRequestTask)this.getTask()).getResult() != null ? ExperimentTaskStatus.SUCCESS : ExperimentTaskStatus.FAILED;
        }
    }

    private class PopulateExperimentPartsState
    extends State {
        protected PopulateExperimentPartsState() {
            super("Processing experiment information");
        }

        @Override
        @Nonnull
        public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            TreeSet<TargetAuthority> authorities = new TreeSet<TargetAuthority>(Comparator.comparing(targetAuthority -> (Integer)targetAuthority.getServerToConnect().getId()));
            if (AllocateExperimentJob.this.allocationDirector instanceof StitchingAllocationDirector) {
                Collection<Server> auths = ((StitchingAllocationDirector)AllocateExperimentJob.this.allocationDirector).getAllAuthorities();
                ArrayList targetAuthorities = new ArrayList();
                for (Server auth : auths) {
                    if (auth.hasFlag(Server.Flag.centralBrokerArchitectureBrokerauth)) {
                        Server connectAuth = AllocateExperimentJob.this.testbedInfoSource.getByUrn(auth.getDefaultComponentManagerUrn(), TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_TOPLEVEL, true);
                        if (connectAuth == null) {
                            AllocateExperimentJob.this.log.error("ERROR: Component Manager Urn for central broker architecture toplevel authority in Request RSpec unknown (connectAuth=null): \"" + auth.getDefaultComponentManagerUrn() + "\".");
                            throw new UnknownAuthorityException(auth.getDefaultComponentManagerAsGeniUrn());
                        }
                        authorities.add(new TargetAuthority(auth.getDefaultComponentManagerAsGeniUrn(), auth, connectAuth));
                        continue;
                    }
                    authorities.add(new TargetAuthority(auth.getDefaultComponentManagerAsGeniUrn(), auth, auth));
                }
            } else {
                assert (AllocateExperimentJob.this.experiment.getSliceOrNull() != null);
                assert (AllocateExperimentJob.this.experiment.getSlice().getRequestRspec() != null);
                for (GeniUrn componentManagerUrn : AllocateExperimentJob.this.experiment.getSlice().getRequestRspec().getAllComponentManagerUrns()) {
                    Server connectAuth = AllocateExperimentJob.this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.CREATE_SLIVER);
                    Server rspecAuth = AllocateExperimentJob.this.authorityFinder.findByUrn(componentManagerUrn, AuthorityFinder.Purpose.REQUEST_RSPEC);
                    if (connectAuth == null) {
                        AllocateExperimentJob.this.log.error("ERROR: Component Manager Urn in Request RSpec unknown (connectAuth=null): \"" + String.valueOf(componentManagerUrn) + "\".");
                        throw new UnknownAuthorityException(componentManagerUrn);
                    }
                    if (rspecAuth == null) {
                        AllocateExperimentJob.this.log.error("ERROR: Component Manager Urn in Request RSpec unknown (rspecAuth=null): \"" + String.valueOf(componentManagerUrn) + "\".");
                        throw new UnknownAuthorityException(componentManagerUrn);
                    }
                    if (connectAuth.isEdgeVlan()) continue;
                    authorities.add(new TargetAuthority(componentManagerUrn, rspecAuth, connectAuth));
                }
            }
            for (TargetAuthority auth : authorities) {
                AllocateExperimentJob.this.experiment.addExperimentPart(new SfaExperimentPart(AllocateExperimentJob.this.experiment, auth.getServerToConnect(), auth.getServerForRspecComponentManager()));
            }
            AllocateExperimentJob.this.epcManager.populateNonSfaExperimentParts(AllocateExperimentJob.this.experiment);
            return ExperimentTaskStatus.SUCCESS;
        }
    }

    public final class CreateNonSfaExperimentPartsContainersState
    extends SlicedState<StateSlice> {
        private final List<StateSlice> slices;

        protected CreateNonSfaExperimentPartsContainersState() {
            super("Creating non-SFA experimentparts containers");
            this.slices = AllocateExperimentJob.this.getNonSfaExperimentPartControllers().stream().map(epc -> epc.initializeContainer(AllocateExperimentJob.this)).collect(Collectors.toList());
        }

        @Override
        public Collection<StateSlice> getSlices() {
            return this.slices;
        }
    }

    public final class StartNonSfaPartsState
    extends SlicedState<StateSlice> {
        private final List<StateSlice> slices;

        protected StartNonSfaPartsState() {
            super("Starting non-SFA resources");
            this.slices = new ArrayList<StateSlice>();
            for (ExperimentPart experimentPart : AllocateExperimentJob.this.experiment.getPartsListCopy()) {
                if (experimentPart instanceof SfaExperimentPart) continue;
                ExperimentPartController epc = AllocateExperimentJob.this.epcManager.getController(experimentPart);
                if (!(epc instanceof NonSfaExperimentPartController)) {
                    throw new RuntimeException("Expected a non-sfa ExperimentPartController");
                }
                this.slices.add(((NonSfaExperimentPartController)epc).start(AllocateExperimentJob.this, experimentPart));
            }
        }

        @Override
        public Collection<StateSlice> getSlices() {
            return this.slices;
        }
    }

    public class AllocateSfaPartsState
    extends SlicedState<AllocatePartStateSlice> {
        private final List<AllocatePartStateSlice> slices;
        private final Map<ExperimentPart, StateSliceThread<AllocatePartStateSlice>> threadMap;

        protected AllocateSfaPartsState() {
            super("Allocate resources with StitchingDirector");
            this.slices = new ArrayList<AllocatePartStateSlice>();
            this.threadMap = new HashMap<ExperimentPart, StateSliceThread<AllocatePartStateSlice>>();
            for (SfaExperimentPart experimentPart : AllocateExperimentJob.this.getSfaParts()) {
                AllocatePartStateSlice allocatePartStateSlice = new AllocatePartStateSlice(experimentPart);
                this.slices.add(allocatePartStateSlice);
                StateSliceThread<AllocatePartStateSlice> thread = new StateSliceThread<AllocatePartStateSlice>(allocatePartStateSlice, this.getName());
                this.threadMap.put(experimentPart, thread);
            }
        }

        @Override
        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            this.threadMap.values().forEach(Thread::start);
            while (AllocateExperimentJob.this.allocationDirector.areAnyActionsLeft()) {
                List<StitchingDirector.StitchAction> stitchActions = AllocateExperimentJob.this.allocationDirector.getStitchActions();
                if (!stitchActions.isEmpty()) {
                    for (StitchingDirector.StitchAction stitchAction : stitchActions) {
                        SfaExperimentPart part = AllocateExperimentJob.this.experiment.getPart(stitchAction.getServer());
                        this.threadMap.get(part).getStateSlice().submitStitchAction(new AllocateAction(stitchAction));
                    }
                } else {
                    AllocateExperimentJob.this.log.trace("No stitchActions available for the moment, but director says it's not finished yet.");
                }
                Thread.sleep(250L);
            }
            this.threadMap.values().forEach(apt -> ((AllocatePartStateSlice)apt.getStateSlice()).submitStitchAction(AllocateAction.createFinishedAction()));
            return AllocateExperimentJob.this.allocationDirector.isGaveUp() ? ExperimentTaskStatus.FAILED : ExperimentTaskStatus.SUCCESS;
        }

        public boolean isPermanentFailure() {
            return AllocateExperimentJob.this.allocationDirector.isGaveUp();
        }

        public Map<ExperimentPart, StateSliceThread<AllocatePartStateSlice>> getThreadMap() {
            return this.threadMap;
        }

        @Override
        public Collection<AllocatePartStateSlice> getSlices() {
            return this.slices;
        }
    }

    public class AllocatePartStateSlice
    extends ExperimentPartStateSlice<SfaExperimentPart> {
        private final Logger log;
        private final BlockingQueue<AllocateAction> queue;
        private int allocateStitchActionRetryCount;

        private AllocatePartStateSlice(SfaExperimentPart experimentPart) {
            super(AllocateExperimentJob.this, experimentPart);
            this.log = AllocateExperimentJob.this.log;
            this.queue = new LinkedBlockingQueue<AllocateAction>();
            this.allocateStitchActionRetryCount = 0;
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            StitchingDirector.StitchAction stitchAction;
            block5: while (true) {
                WaitForNextAllocateActionState waitForNextAllocateActionState = new WaitForNextAllocateActionState();
                this.setAndRunState(waitForNextAllocateActionState);
                AllocateAction allocateAction = waitForNextAllocateActionState.getAllocateAction();
                if (allocateAction.isFinished()) {
                    return ExperimentTaskStatus.SUCCESS;
                }
                stitchAction = allocateAction.getStitchAction();
                switch (stitchAction.getType()) {
                    case ALLOCATE: {
                        this.processAllocateStitchAction(stitchAction);
                        continue block5;
                    }
                    case DELETE: {
                        this.processDeleteStitchAction();
                        continue block5;
                    }
                    case LISTRESOURCES: {
                        this.processListResourcesStitchAction();
                        continue block5;
                    }
                }
                break;
            }
            throw new IllegalArgumentException("Unexpected StitchAction: " + String.valueOf(stitchAction));
        }

        private void processListResourcesStitchAction() throws InterruptedException {
            GetAdvertisementState getAdvertisementState = new GetAdvertisementState();
            try {
                this.setAndRunState(getAdvertisementState);
            }
            catch (JFedException e) {
                this.log.error("Error while performing ListResources on {}", (Object)((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority(), (Object)e);
            }
            AllocateExperimentJob.this.allocationDirector.processListResourcesResult(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority(), ((GetAdvertisementTask)getAdvertisementState.getTask()).getAdvertisementRspecString());
        }

        private void processDeleteStitchAction() throws InterruptedException, JFedException {
            StopExperimentAtAuthorityPartState stopExperimentAtAuthorityPartState = AllocateExperimentJob.this.jobStateFactory.createStopExperimentAtAuthorityPartState(AllocateExperimentJob.this, (SfaExperimentPart)this.experimentPart);
            try {
                this.setAndRunState(stopExperimentAtAuthorityPartState);
            }
            catch (JFedException e) {
                this.log.error("Error while deleting resources from experiment", (Throwable)e);
            }
            finally {
                AllocateExperimentJob.this.allocationDirector.processDeleteResult(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processAllocateStitchAction(StitchingDirector.StitchAction stitchAction) throws InterruptedException, JFedException {
            AbstractGeniAggregateManager.AggregateManagerReply reply;
            block13: {
                ImmutableRequestRspecSource overridingRequestRspecSource = stitchAction.getRequestRspec() != null ? new ImmutableRequestRspecSource(new StringRspec(stitchAction.getRequestRspec())) : null;
                AllocateSliversOnAuthorityState allocateSliversOnAuthorityState = AllocateExperimentJob.this.jobStateFactory.createAllocateSliversOnAuthorityState(AllocateExperimentJob.this, (SfaExperimentPart)this.experimentPart, this.experiment.getUserSpecs(), (RequestRspecSource)overridingRequestRspecSource);
                reply = null;
                try {
                    JFedException e;
                    this.setAndRunState(allocateSliversOnAuthorityState);
                    if (allocateSliversOnAuthorityState.isSuccess()) {
                        reply = allocateSliversOnAuthorityState.getRawReply();
                        break block13;
                    }
                    if (allocateSliversOnAuthorityState.getException() instanceof AggregateManagerWrapper.VlanUnavailableException || allocateSliversOnAuthorityState.getException() instanceof AggregateManagerWrapper.AnyVlanUnsupportedException) {
                        e = (JFedException)allocateSliversOnAuthorityState.getException();
                        assert (e.getSfaReply() == null || e.getSfaReply() instanceof AbstractGeniAggregateManager.AggregateManagerReply) : "Unexpected reply type: " + e.getSfaReply().getClass().getName();
                        reply = (AbstractGeniAggregateManager.AggregateManagerReply)e.getSfaReply();
                        break block13;
                    }
                    if (allocateSliversOnAuthorityState.getException() instanceof AggregateManagerWrapper.NotEnoughFreeResourcesException) {
                        e = (JFedException)allocateSliversOnAuthorityState.getException();
                        assert (e.getSfaReply() == null || e.getSfaReply() instanceof AbstractGeniAggregateManager.AggregateManagerReply) : "Unexpected reply type: " + e.getSfaReply().getClass().getName();
                        this.log.info("AllocateExperimentJob.processAllocateStitchAction(): Saw a NotEnoughFreeResourcesException. Will fail allocationDirector and log it in experiment.");
                        AllocateExperimentJob.this.allocationDirector.reportGiveUp();
                        ((SfaExperimentPart)this.experimentPart).setSawNotEnoughFreeResourcesError(true);
                        assert (this.experiment.getAnyPartSawNotEnoughFreeResourcesError());
                        break block13;
                    }
                    if (allocateSliversOnAuthorityState.getException() instanceof JFedException) {
                        e = (JFedException)allocateSliversOnAuthorityState.getException();
                        if (e.getSfaReply() != null && e.getSfaReply() instanceof AbstractGeniAggregateManager.AggregateManagerReply) {
                            reply = (AbstractGeniAggregateManager.AggregateManagerReply)e.getSfaReply();
                            break block13;
                        } else {
                            if (!Objects.equals(StitchingDirector.isUnrecoverableError((JFedException)e), Boolean.TRUE)) {
                                this.log.info("There was an error ({} code={}) allocating on {}, requesting retry", new Object[]{e.getMessage(), e.getGeniResponseCode(), ((SfaExperimentPart)this.experimentPart).getName()});
                                this.retryAllocate(stitchAction);
                                return;
                            }
                            this.log.error("Giving up as {} reported an unrecoverable error {}", (Object)((SfaExperimentPart)this.experimentPart).getName(), (Object)e.getMessage());
                            AllocateExperimentJob.this.allocationDirector.reportGiveUp();
                        }
                        break block13;
                    }
                    this.log.error("Unexpected state: unknown error while allocating", allocateSliversOnAuthorityState.getException());
                }
                catch (JFedException ex) {
                    this.log.error("UNEXPECTED error while allocating", (Throwable)ex);
                }
            }
            this.log.trace("   Processing result of CreateSliver call for " + ((SfaExperimentPart)this.experimentPart).getName());
            StitchingDirector.AllocateVerdict verdict = AllocateExperimentJob.this.allocationDirector.processAllocateResult(stitchAction, reply);
            if (verdict == StitchingDirector.AllocateVerdict.CALLER_DELAYED_RETRY) {
                this.log.info("There was a {} verdict when allocating on {}, requesting retry", (Object)verdict, (Object)((SfaExperimentPart)this.experimentPart).getName());
                this.retryAllocate(stitchAction);
            }
        }

        private void retryAllocate(StitchingDirector.StitchAction stitchAction) throws InterruptedException {
            if (++this.allocateStitchActionRetryCount > 3) {
                this.log.error("Giving up stitching as number of allocation tries on {} exceeded maximum of {}", (Object)((SfaExperimentPart)this.experimentPart).getName(), (Object)3);
                AllocateExperimentJob.this.allocationDirector.reportGiveUp();
                return;
            }
            this.log.info("retryAllocate: CreateSliver failed (allocateStitchActionRetryCount=" + this.allocateStitchActionRetryCount + "), will delete and try again in 10000ms now=" + HtmlLogOutput.dateToString((Date)new Date()));
            Thread.sleep(10000L);
            AllocateExperimentJob.this.allocationDirector.reportReadyForRetry(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority());
        }

        public void submitStitchAction(AllocateAction stitchAction) {
            boolean success = this.queue.offer(stitchAction);
            assert (success) : "Could not add StitchAction to ExperimentPart " + ((SfaExperimentPart)this.experimentPart).getName();
        }

        public class WaitForNextAllocateActionState
        extends State {
            private AllocateAction allocateAction;

            protected WaitForNextAllocateActionState() {
                super("Waiting for next StitchAction instruction");
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                this.allocateAction = AllocatePartStateSlice.this.queue.take();
                return ExperimentTaskStatus.SUCCESS;
            }

            public AllocateAction getAllocateAction() {
                return this.allocateAction;
            }
        }

        public class GetAdvertisementState
        extends SingleCallState<GetAdvertisementTask> {
            protected GetAdvertisementState() {
                super("Fetch advertisement from " + ((SfaExperimentPart)AllocatePartStateSlice.this.experimentPart).getName() + " for list of available VLAN's", AllocateExperimentJob.this.hltf.getAvailableAdvertisement(((SfaExperimentPart)AllocatePartStateSlice.this.experimentPart).getConnectSfaAuthority()));
            }
        }
    }

    private static class AllocateAction {
        private final boolean finished;
        private final StitchingDirector.StitchAction stitchAction;

        public AllocateAction(StitchingDirector.StitchAction stitchAction) {
            this.stitchAction = stitchAction;
            this.finished = false;
        }

        private AllocateAction() {
            this.stitchAction = null;
            this.finished = true;
        }

        public static AllocateAction createFinishedAction() {
            return new AllocateAction();
        }

        public boolean isFinished() {
            return this.finished;
        }

        public StitchingDirector.StitchAction getStitchAction() {
            return this.stitchAction;
        }

        public String toString() {
            return "AllocateAction{finished=" + this.finished + ", stitchAction=" + String.valueOf(this.stitchAction) + "}";
        }
    }
}

