/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultipleCallState<T extends Task>
extends State {
    private static final Logger LOG = LoggerFactory.getLogger(MultipleCallState.class);
    private final AbstractJob<?> job;
    protected final Map<T, TaskExecution<T>> taskExecutions = new HashMap<T, TaskExecution<T>>();

    protected MultipleCallState(String name, AbstractJob<?> job) {
        super(name);
        this.job = job;
    }

    @Override
    @Nonnull
    public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
        this.updateMessage("Preparing...");
        Collection<T> tasks = this.getTasks();
        CountDownLatch latch = new CountDownLatch(tasks.size());
        for (Task task : tasks) {
            TaskExecution<Task> taskExecution = this.job.submitTask(task, (t, te, s) -> {
                this.onTaskExecutionFinished(t, te, s);
                latch.countDown();
            });
            this.taskExecutions.put(task, taskExecution);
        }
        this.updateMessage("Executing tasks...");
        latch.await();
        this.updateMessage("Done. Checking status...");
        for (TaskExecution taskExecution : this.taskExecutions.values()) {
            if (taskExecution.getState() == TaskExecution.TaskState.FAILED) {
                this.updateMessage("At least one task failed");
                return ExperimentTaskStatus.FAILED;
            }
            assert (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) : "unexpected state " + String.valueOf((Object)taskExecution.getState());
        }
        this.updateMessage("All tasks succeeded");
        return ExperimentTaskStatus.SUCCESS;
    }

    protected void onTaskExecutionFinished(T task, TaskExecution<T> taskExecution, TaskExecution.TaskState state) {
    }

    public abstract Collection<T> getTasks();

    public Map<T, TaskExecution<T>> getTaskExecutions() {
        return Collections.unmodifiableMap(this.taskExecutions);
    }
}

