/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.RenewSliceTask;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RenewJob
extends AbstractJob<ExperimentTaskStatus> {
    @Nonnull
    private final Instant newExpirationDate;
    @Nullable
    private final Collection<ExperimentPart> experimentParts;
    @Nullable
    private final boolean renewSliceOnly;
    @Nonnull
    private final ExperimentPartControllerManager epcManager;
    private List<ExperimentPart> failedParts;
    private boolean renewSliceFailed;

    public RenewJob(@Nonnull Experiment experiment, @Nonnull Instant newExpirationDate, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull ExperimentPartControllerManager epcManager, boolean renewSliceOnly) {
        super("Renew " + (renewSliceOnly ? "slice" : "experiment") + " until " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(newExpirationDate, ZoneId.systemDefault())), experiment, hltf, tt);
        this.newExpirationDate = newExpirationDate;
        this.epcManager = epcManager;
        this.experimentParts = null;
        this.renewSliceOnly = renewSliceOnly;
    }

    public RenewJob(@Nonnull Experiment experiment, @Nonnull Instant newExpirationDate, @Nonnull Collection<ExperimentPart> experimentParts, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull ExperimentPartControllerManager epcManager) {
        super("Renew experiment until " + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.ofInstant(newExpirationDate, ZoneId.systemDefault())), experiment, hltf, tt);
        this.newExpirationDate = newExpirationDate;
        this.experimentParts = experimentParts;
        this.epcManager = epcManager;
        this.renewSliceOnly = false;
    }

    @Override
    public ExperimentTaskStatus execute() throws Exception {
        this.renewSliceFailed = false;
        assert (this.experiment.getSliceOrNull() != null);
        if (this.experiment.getSlice().getExpirationDate() == null || this.newExpirationDate.isAfter(this.experiment.getSlice().getExpirationDate())) {
            RenewSliceState renewSliceState = new RenewSliceState();
            this.setAndRunState(renewSliceState);
            boolean bl = this.renewSliceFailed = renewSliceState.getStatus() != ExperimentTaskStatus.SUCCESS;
        }
        if (this.renewSliceFailed) {
            throw new JFedHighLevelException("Could not renew slice!");
        }
        if (this.renewSliceOnly) {
            this.failedParts = Collections.emptyList();
            return ExperimentTaskStatus.SUCCESS;
        }
        RenewExperimentPartsState renewPartsState = new RenewExperimentPartsState();
        this.setAndRunState(renewPartsState);
        this.failedParts = renewPartsState.getSlices().stream().filter(js -> js.getResult() != ExperimentTaskStatus.SUCCESS).map(experimentPartStateSlice -> experimentPartStateSlice.getExperimentPart()).collect(Collectors.toList());
        if (!this.failedParts.isEmpty()) {
            this.updateMessage("Renewing failed at " + this.failedParts.stream().map(ExperimentPart::getName).collect(Collectors.joining(", ")));
        }
        return renewPartsState.getStatus();
    }

    public boolean isRenewSliceFailed() {
        return this.renewSliceFailed;
    }

    public List<ExperimentPart> getFailedParts() {
        return Collections.unmodifiableList(this.failedParts);
    }

    private class RenewSliceState
    extends SingleCallState<RenewSliceTask> {
        protected RenewSliceState() {
            super("Renewing experiment container", RenewJob.this.hltf.renewSlice(RenewJob.this.experiment.getSlice(), RenewJob.this.newExpirationDate));
        }
    }

    private class RenewExperimentPartsState
    extends ExperimentPartsSlicedState<ExperimentPartStateSlice> {
        protected RenewExperimentPartsState() {
            super("Renewing resources at %d authorities", RenewJob.this.experiment, RenewJob.this.experimentParts, RenewJob.this.epcManager);
        }

        @Override
        public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
            return controller.renew(RenewJob.this, experimentPart, RenewJob.this.newExpirationDate);
        }
    }
}

