/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.MultipleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.OtherUserSshKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.ShareSliceTask;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareSliceJob
extends AbstractJob<ExperimentTaskStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(ShareSliceJob.class);
    private final Experiment experiment;
    private final Collection<GeniUrn> usersToShareWith;
    private final boolean registerSshKey;
    private final JobStateFactory jobStateFactory;

    public ShareSliceJob(Experiment experiment, Collection<GeniUrn> usersToShareWith, boolean registerSshKey, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory) {
        super(String.format("Share slice %s with %d users", experiment.getName(), usersToShareWith.size()), experiment, hltf, tt);
        this.experiment = experiment;
        this.usersToShareWith = usersToShareWith;
        this.registerSshKey = registerSshKey;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public ExperimentTaskStatus execute() throws Exception {
        ShareSliceWithUsersState shareSliceWithUsersState = new ShareSliceWithUsersState();
        this.setAndRunState(shareSliceWithUsersState);
        if (shareSliceWithUsersState.getStatus() == ExperimentTaskStatus.FAILED) {
            throw new JFedHighLevelException("Could not share slice!");
        }
        if (this.registerSshKey) {
            FetchUserKeysState fetchUserKeysState = new FetchUserKeysState();
            this.setAndRunState(fetchUserKeysState);
            if (fetchUserKeysState.getUserSpecs() != null) {
                this.setAndRunState(this.jobStateFactory.createUpdateSshKeysState(this, fetchUserKeysState.getUserSpecs()));
            } else {
                LOG.warn("Not applying SSH keys to authorities as fetching keys failed");
            }
        }
        return ExperimentTaskStatus.SUCCESS;
    }

    public class ShareSliceWithUsersState
    extends MultipleCallState<ShareSliceTask> {
        ShareSliceWithUsersState() {
            super(String.format("Share slice %s with %d users", ShareSliceJob.this.experiment.getName(), ShareSliceJob.this.usersToShareWith.size()), ShareSliceJob.this);
        }

        @Override
        public Collection<ShareSliceTask> getTasks() {
            LOG.debug("ShareSliceWithUsersState getTasks init");
            return ShareSliceJob.this.usersToShareWith.stream().map(user -> ShareSliceJob.this.hltf.getShareSliceTask(ShareSliceJob.this.experiment.getSliceOrNull(), (GeniUrn)user)).collect(Collectors.toList());
        }
    }

    public class FetchUserKeysState
    extends MultipleCallState<OtherUserSshKeysTask> {
        private final List<UserSpec> newUserSpecs;
        private final IntegerProperty successfulCalls;
        private final IntegerProperty failedCalls;

        protected FetchUserKeysState() {
            super(String.format("Fetching SSH keys of %d users", ShareSliceJob.this.usersToShareWith.size()), ShareSliceJob.this);
            this.newUserSpecs = Collections.synchronizedList(new ArrayList());
            this.successfulCalls = new SimpleIntegerProperty(0);
            this.failedCalls = new SimpleIntegerProperty(0);
        }

        @Override
        public Collection<OtherUserSshKeysTask> getTasks() {
            return ShareSliceJob.this.usersToShareWith.stream().map(ShareSliceJob.this.hltf::getOtherUserSshKeys).collect(Collectors.toList());
        }

        @Override
        protected void onTaskExecutionFinished(OtherUserSshKeysTask task, TaskExecution<OtherUserSshKeysTask> taskExecution, TaskExecution.TaskState state) {
            if (taskExecution.getState() == TaskExecution.TaskState.SUCCESS) {
                this.newUserSpecs.add(new UserSpec(task.getUserUrn().toString(), task.getKeys()));
                this.successfulCalls.set(this.successfulCalls.get() + 1);
            } else {
                this.failedCalls.set(this.failedCalls.get() + 1);
            }
        }

        public List<UserSpec> getUserSpecs() {
            return this.newUserSpecs;
        }
    }
}

