/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.HostAndPortTest;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.CorePreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConnectivityJob
extends AbstractJob<TestConnectivityJobResult> {
    private static final Logger LOG = LoggerFactory.getLogger(TestConnectivityJob.class);
    private static final int WAIT_BETWEEN_TESTS = 10;
    private static final int MAX_TESTS = 12;
    private final GeniUserProvider geniUserProvider;
    private final JFedPreferences jFedPreferences;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final ProxyServiceUtil proxyServiceUtil;
    private final List<FXRspecNode> failedNodes = Collections.synchronizedList(new ArrayList());
    private final List<FXRspecNode> successfulNodes = Collections.synchronizedList(new ArrayList());

    public TestConnectivityJob(Experiment experiment, HighLevelTaskFactory hltf, TaskThread tt, GeniUserProvider geniUserProvider, JFedPreferences jFedPreferences, ProxyPreferencesManager proxyPreferencesManager, ProxyServiceUtil proxyServiceUtil) {
        super("Test connectivity to resources", experiment, hltf, tt);
        this.geniUserProvider = geniUserProvider;
        this.jFedPreferences = jFedPreferences;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.proxyServiceUtil = proxyServiceUtil;
    }

    @Override
    public TestConnectivityJobResult execute() throws Exception {
        LOG.trace("Starting connectivity tests to existing resources in experiment {}", (Object)this.experiment.getName());
        TestConnectivityToExperimentPartsState tcs = new TestConnectivityToExperimentPartsState();
        this.setAndRunState(tcs);
        return new TestConnectivityJobResult(tcs.getStatus() == ExperimentTaskStatus.SUCCESS, this.failedNodes, this.successfulNodes);
    }

    public class TestConnectivityToExperimentPartsState
    extends SlicedState<TestConnectivityToExperimentPartStateSlice> {
        private final List<TestConnectivityToExperimentPartStateSlice> slices;

        protected TestConnectivityToExperimentPartsState() {
            super("Test connectivity to experiment parts");
            this.slices = TestConnectivityJob.this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(x$0 -> new TestConnectivityToExperimentPartStateSlice((ExperimentPart)x$0)).collect(Collectors.toList());
        }

        @Override
        public Collection<TestConnectivityToExperimentPartStateSlice> getSlices() {
            return this.slices;
        }

        public List<FXRspecNode> getFailedNodes() {
            return TestConnectivityJob.this.failedNodes;
        }

        public List<FXRspecNode> getSuccessfulNodes() {
            return TestConnectivityJob.this.successfulNodes;
        }
    }

    public static class TestConnectivityJobResult {
        private boolean allSuccessFull;
        @Nonnull
        private final List<FXRspecNode> failedNodes;
        @Nonnull
        private final List<FXRspecNode> successfulNodes;

        public TestConnectivityJobResult(boolean allSuccessFull, @Nonnull List<FXRspecNode> failedNodes, @Nonnull List<FXRspecNode> successfulNodes) {
            this.allSuccessFull = allSuccessFull;
            this.failedNodes = Collections.unmodifiableList(new ArrayList<FXRspecNode>(failedNodes));
            this.successfulNodes = Collections.unmodifiableList(new ArrayList<FXRspecNode>(successfulNodes));
        }

        public static TestConnectivityJobResult createFalseEmpty() {
            return new TestConnectivityJobResult(false, Collections.emptyList(), Collections.emptyList());
        }

        public boolean isAllSuccessFull() {
            return this.allSuccessFull;
        }

        @Nonnull
        public List<FXRspecNode> getFailedNodes() {
            return this.failedNodes;
        }

        @Nonnull
        public List<FXRspecNode> getSuccessfulNodes() {
            return this.successfulNodes;
        }
    }

    public class TestConnectivityToExperimentPartState
    extends State {
        private final ExperimentPart experimentPart;
        private final Collection<FXRspecNode> nodesToTest;
        private int currentTestCount;
        private final Map<FXRspecNode, ConnectivityTest.Status> nodesConnectivity;

        private TestConnectivityToExperimentPartState(ExperimentPart experimentPart, Collection<FXRspecNode> nodesToTest) {
            super(String.format("Testing connectivity to resources on %s", experimentPart.getName()));
            this.currentTestCount = 0;
            this.nodesConnectivity = new HashMap<FXRspecNode, ConnectivityTest.Status>();
            this.experimentPart = experimentPart;
            this.nodesToTest = nodesToTest;
        }

        @Override
        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            assert (!this.nodesToTest.isEmpty());
            assert (this.experimentPart instanceof SfaExperimentPart);
            assert (((SfaExperimentPart)this.experimentPart).getSlivers() != null);
            for (Sliver sliver : ((SfaExperimentPart)this.experimentPart).getSlivers()) {
                assert (sliver != null);
                assert (sliver.getStatus().getGlobalStatus() == StatusDetails.SliverStatus.READY);
                assert (sliver.isFake() || sliver.getManifestRspec() != null);
            }
            JFedConnection.SshProxyInfo proxyInfo = null;
            if (Objects.equals(TestConnectivityJob.this.jFedPreferences.getString((JFedPreferences.PreferenceKey)CorePreferenceKey.PREF_SSHPROXY_USE_FOR_SSH), "ALWAYS")) {
                GeniUser geniUser = TestConnectivityJob.this.geniUserProvider.getLoggedInGeniUser();
                assert (geniUser.getUserAuthorityServer() != null);
                List userAuthProxyInfos = geniUser.getUserAuthorityServer().getTestbed().getProxies();
                proxyInfo = TestConnectivityJob.this.proxyPreferencesManager.getSshProxySettings(userAuthProxyInfos, geniUser);
                if (proxyInfo == null) {
                    LOG.warn("Connectivity tests to nodes on authority {} are skipped as SSH-proxy is active but proxy info was not found. (this is a jFed bug)", (Object)this.experimentPart.getName());
                    this.updateMessage("Skipped because proxy for SSH-connections is active but proxy info was not found. (this is a jFed bug)");
                    return ExperimentTaskStatus.FAILED;
                }
            }
            LOG.debug("Starting nodes connectivity test for {} nodes on {}", (Object)this.nodesToTest.size(), (Object)this.experimentPart.getName());
            Iterator<FXRspecNode> it = this.nodesToTest.iterator();
            while (it.hasNext()) {
                FXRspecNode node = it.next();
                if (!node.getLoginServices().isEmpty()) continue;
                LOG.debug("Removing node {} from test because it doesn't have any loginServices available", (Object)node.getUniqueId());
                it.remove();
            }
            int successCount = 0;
            while (this.currentTestCount < 12) {
                LOG.trace("Starting connectivity test round {} to {}", (Object)(this.currentTestCount + 1), (Object)this.experimentPart.getName());
                this.updateMessage(String.format("Could connect to %d out of %d nodes. Testing... ", successCount, this.nodesToTest.size()));
                for (FXRspecNode node : this.nodesToTest) {
                    if (this.nodesConnectivity.containsKey(node) && this.nodesConnectivity.get(node) == ConnectivityTest.Status.SUCCEEDED) continue;
                    ConnectivityTest.Status result = this.testConnectToNode(node, (JFedConnection.ProxyInfo)proxyInfo);
                    if (result == ConnectivityTest.Status.SUCCEEDED) {
                        this.updateMessage(String.format("Could connect to %d out of %d nodes. Testing... ", ++successCount, this.nodesToTest.size()));
                        LOG.trace("Could successfully connect to node {}@{} in test round {}", new Object[]{node.getClientId(), this.experimentPart.getName(), this.currentTestCount + 1});
                    } else {
                        LOG.trace("Got result {} when connecting to node {}@{} in test round {}", new Object[]{result, node.getClientId(), this.experimentPart.getName(), this.currentTestCount + 1});
                    }
                    this.nodesConnectivity.put(node, result);
                }
                if (successCount == this.nodesToTest.size()) {
                    this.updateMessage("");
                    return ExperimentTaskStatus.SUCCESS;
                }
                LOG.trace("Could connect to {} of {} nodes in round {}", new Object[]{successCount, this.nodesToTest.size(), this.currentTestCount + 1});
                this.updateMessage("Could connect to " + successCount + " of " + this.nodesToTest.size() + " requested nodes.");
                ++this.currentTestCount;
                for (int waitLeft = 10; this.currentTestCount < 12 && waitLeft > 0; --waitLeft) {
                    this.updateMessage(String.format("Could connect to %d out of %d nodes. Trying again in %d seconds... ", successCount, this.nodesToTest.size(), waitLeft));
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return ExperimentTaskStatus.FAILED;
        }

        private ConnectivityTest.Status testConnectToNode(FXRspecNode node, JFedConnection.ProxyInfo proxyInfo) {
            HostAndPortTest hostAndPortTest;
            ConnectivityTest.ConnectivityTestResult result;
            LoginService loginService = (LoginService)node.getLoginServices().get(0);
            LOG.trace("Going to try to connect to {} by using loginService {}:{}", new Object[]{node.getUniqueId(), loginService.getHostname(), loginService.getPort()});
            JFedConnection.SshProxyInfo testbedProxyInfo = TestConnectivityJob.this.proxyServiceUtil.findTestbedProxy((RspecNode)node, loginService);
            if (testbedProxyInfo != null) {
                LOG.trace("Trying to make connection to {} with testbed proxy {}", (Object)node.getUniqueId(), (Object)testbedProxyInfo);
            }
            if (proxyInfo != null && testbedProxyInfo != null) {
                LOG.warn("jFed has proxy currently enabled. However, connectivity test will only use testbed proxy {} while trying to connect to {}!", (Object)testbedProxyInfo, (Object)node.getUniqueId());
            }
            if ((result = (hostAndPortTest = new HostAndPortTest(loginService.getHostname(), Integer.parseInt(loginService.getPort()), null, null, (JFedConnection.ProxyInfo)(testbedProxyInfo == null ? proxyInfo : testbedProxyInfo))).call()).getStatus() != ConnectivityTest.Status.SUCCEEDED) {
                return result.getStatus();
            }
            return ConnectivityTest.Status.SUCCEEDED;
        }
    }

    public class FindTestableResourcesState
    extends State {
        private final ExperimentPart experimentPart;
        private Collection<FXRspecNode> nodesToTest;

        private FindTestableResourcesState(ExperimentPart experimentPart) {
            super(String.format("Determining testable resources on %s", experimentPart.getName()));
            this.nodesToTest = null;
            this.experimentPart = experimentPart;
        }

        @Override
        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            HashMap<String, FXRspecNode> nodesOfAuthorityWithLoginService = new HashMap<String, FXRspecNode>();
            HashSet<String> nodeIdsWithoutLoginService = new HashSet<String>();
            if (!(this.experimentPart instanceof SfaExperimentPart)) {
                LOG.debug("Currently no support for connectivity testing of {}", (Object)this.experimentPart.getClass().getName());
                this.nodesToTest = Collections.emptyList();
                return ExperimentTaskStatus.WARNING;
            }
            SfaExperimentPart sfaExperimentPart = (SfaExperimentPart)this.experimentPart;
            assert (sfaExperimentPart.getSlivers() != null);
            for (Sliver sliver : sfaExperimentPart.getSlivers()) {
                if (sliver.isFake() || sliver.isVirtual()) continue;
                if (sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.READY) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cannot start connectivity test to {} as sliver {} is not READY", (Object)this.experimentPart.getName(), (Object)sliver.getUrn());
                    }
                    return ExperimentTaskStatus.WARNING;
                }
                if (sliver.getManifestRspec() == null) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Cannot start connectivity test to {} as manifest is not available for sliver {}", (Object)this.experimentPart.getName(), (Object)sliver.getUrn());
                    }
                    return ExperimentTaskStatus.WARNING;
                }
                FXModelRspec modelRspec = (FXModelRspec)sliver.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
                assert (modelRspec != null);
                List nodes = modelRspec.getNodesByAuthority(sfaExperimentPart.getConnectSfaAuthority());
                assert (nodes != null);
                for (FXRspecNode node : nodes) {
                    if (!node.getLoginServices().isEmpty()) {
                        if (nodesOfAuthorityWithLoginService.containsKey(node.getUniqueId())) continue;
                        nodesOfAuthorityWithLoginService.put(node.getUniqueId(), node);
                        nodeIdsWithoutLoginService.remove(node.getUniqueId());
                        continue;
                    }
                    if (nodesOfAuthorityWithLoginService.containsKey(node.getUniqueId())) continue;
                    nodeIdsWithoutLoginService.add(node.getUniqueId());
                }
            }
            if (!nodesOfAuthorityWithLoginService.isEmpty()) {
                this.nodesToTest = nodesOfAuthorityWithLoginService.values();
            } else if (!nodeIdsWithoutLoginService.isEmpty()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Cannot start connectivity test for authority {} as no nodes with loginServices are available", (Object)this.experimentPart.getName());
                }
                this.nodesToTest = Collections.emptyList();
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("No connectivity test will be performed for authority {}, as it isn't responsible for any nodes", (Object)this.experimentPart.getName());
                }
                this.nodesToTest = Collections.emptyList();
            }
            return ExperimentTaskStatus.SUCCESS;
        }

        public Collection<FXRspecNode> getNodesToTest() {
            return this.nodesToTest;
        }
    }

    public class TestConnectivityToExperimentPartStateSlice
    extends ExperimentPartStateSlice {
        private TestConnectivityToExperimentPartStateSlice(ExperimentPart experimentPart) {
            super(TestConnectivityJob.this, experimentPart);
        }

        @Override
        public String getName() {
            return "Testing connectivity to resources in " + this.experimentPart.getName();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            FindTestableResourcesState findTestableResourcesState = new FindTestableResourcesState(this.experimentPart);
            this.setAndRunState(findTestableResourcesState);
            if (findTestableResourcesState.getStatus() == ExperimentTaskStatus.SUCCESS && !findTestableResourcesState.getNodesToTest().isEmpty()) {
                TestConnectivityToExperimentPartState tcs = new TestConnectivityToExperimentPartState(this.experimentPart, findTestableResourcesState.getNodesToTest());
                this.setAndRunState(tcs);
                tcs.nodesConnectivity.entrySet().stream().filter(entry -> entry.getValue() != ConnectivityTest.Status.SUCCEEDED).map(Map.Entry::getKey).forEach(TestConnectivityJob.this.failedNodes::add);
                tcs.nodesConnectivity.entrySet().stream().filter(entry -> entry.getValue() == ConnectivityTest.Status.SUCCEEDED).map(Map.Entry::getKey).forEach(TestConnectivityJob.this.successfulNodes::add);
                return tcs.getStatus();
            }
            LOG.debug("Skipping: no testable resources found");
            return ExperimentTaskStatus.SUCCESS;
        }
    }
}

