/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.parts;

import be.iminds.ilabt.jfed.experiment.CapabilityChecker;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentPartsContainer;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.NonSfaExperimentPartController;
import java.util.HashMap;
import java.util.Map;

public class ExperimentPartControllerManager
implements CapabilityChecker {
    private final Map<Class<? extends ExperimentPart>, ExperimentPartController> controllerMap = new HashMap<Class<? extends ExperimentPart>, ExperimentPartController>();
    private final Map<Class<? extends ExperimentPartsContainer>, NonSfaExperimentPartController> containerControllerMap = new HashMap<Class<? extends ExperimentPartsContainer>, NonSfaExperimentPartController>();

    public ExperimentPartControllerManager(boolean ignored) {
    }

    public <EP extends ExperimentPart> void registerController(Class<EP> clazz, ExperimentPartController<EP> controller) {
        NonSfaExperimentPartController nonSfaController;
        Class containerClazz;
        Class<EP> classToCheck = clazz;
        do {
            if (!this.controllerMap.containsKey(classToCheck)) continue;
            throw new IllegalArgumentException("There is already a controller registered for class " + classToCheck.getName());
        } while ((classToCheck = classToCheck.getSuperclass()) != ExperimentPart.class);
        this.controllerMap.put(clazz, controller);
        if (controller instanceof NonSfaExperimentPartController && (containerClazz = (nonSfaController = (NonSfaExperimentPartController)controller).getContainerClass()) != null) {
            if (this.containerControllerMap.containsKey(containerClazz)) {
                throw new IllegalArgumentException("There is already a controller registered for container class " + containerClazz.getName());
            }
            this.containerControllerMap.put(containerClazz, nonSfaController);
        }
    }

    public void populateNonSfaExperimentParts(Experiment experiment) {
        for (ExperimentPartController experimentPartController : this.controllerMap.values()) {
            if (!(experimentPartController instanceof NonSfaExperimentPartController)) continue;
            ((NonSfaExperimentPartController)experimentPartController).populateExperimentParts(experiment);
        }
    }

    public <EP extends ExperimentPart> ExperimentPartController<EP> getController(ExperimentPart experimentPart) {
        if (!this.controllerMap.containsKey(experimentPart.getClass())) {
            throw new RuntimeException("No Controller available for ExperimentPart-class " + experimentPart.getClass().getName());
        }
        return this.controllerMap.get(experimentPart.getClass());
    }

    public <EP extends ExperimentPart, EPC extends ExperimentPartsContainer> NonSfaExperimentPartController<EP, EPC> getContainerController(EPC container) {
        if (!this.containerControllerMap.containsKey(container.getClass())) {
            throw new RuntimeException("No controller available for ExperimentPartsContainer-ckass " + container.getClass().getName());
        }
        return this.containerControllerMap.get(container.getClass());
    }

    @Override
    public boolean supportsRenew(ExperimentPart experimentPart) {
        return this.getController(experimentPart).supportsRenew(experimentPart);
    }

    @Override
    public boolean supportsEditSSHKeys(ExperimentPart experimentPart) {
        return this.getController(experimentPart).supportsEditSshKeys(experimentPart);
    }
}

