/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.report;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import java.time.Instant;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;

public class JobStateReport {
    @Nonnull
    private final String stateName;
    @Nonnull
    private final Instant startTime;
    private final ObjectProperty<Instant> endTime = new SimpleObjectProperty();
    private final ObservableList<TaskExecution<?>> taskExecutions = FXCollections.observableArrayList();
    private final ObjectProperty<ExperimentTaskStatus> finalStatus = new SimpleObjectProperty();
    private final ObservableList<LogOutput.LogEntry> logLines = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());

    public JobStateReport(@Nonnull State state) {
        this.stateName = state.getName();
        this.startTime = Instant.now();
    }

    public void registerEnd(@Nonnull ExperimentTaskStatus finalStatus) {
        this.endTime.set((Object)Instant.now());
        this.finalStatus.set((Object)finalStatus);
    }

    public void addTaskExecution(@Nonnull TaskExecution<?> taskExecution) {
        this.taskExecutions.add(taskExecution);
    }

    public void addLogLine(@Nonnull LogOutput.LogEntry logEntry) {
        this.logLines.add((Object)logEntry);
    }

    @Nonnull
    public String getStateName() {
        return this.stateName;
    }

    @Nonnull
    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return (Instant)this.endTime.get();
    }

    public ObjectProperty<Instant> endTimeProperty() {
        return this.endTime;
    }

    public ObservableList<TaskExecution<?>> getTaskExecutions() {
        return this.taskExecutions;
    }

    public ExperimentTaskStatus getFinalStatus() {
        return (ExperimentTaskStatus)((Object)this.finalStatus.get());
    }

    public ObjectProperty<ExperimentTaskStatus> finalStatusProperty() {
        return this.finalStatus;
    }

    public ObservableList<LogOutput.LogEntry> getLogLines() {
        return this.logLines;
    }
}

