/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.report;

import be.iminds.ilabt.jfed.call_log_output.HtmlLogOutput;
import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobStateReport;
import be.iminds.ilabt.jfed.highlevel.jobs.report.StitchingJobReport;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import org.rendersnake.HtmlCanvas;

public class StitchingJobReportWriter
extends HtmlLogOutput {
    private final StitchingJobReport jobReport;
    private final ApiCallDetailsCache cache;

    public StitchingJobReportWriter(StitchingJobReport jobReport, ApiCallDetailsCache cache) {
        super("Start Stitching Experiment Report");
        this.jobReport = jobReport;
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void htmlContent(HtmlCanvas html) throws IOException {
        StitchingJobReportWriter.addClassVisibleToggle((HtmlCanvas)html, (String)"logline-DEBUG", (String)"Debug Log Lines");
        int index = 0;
        for (JobStateReport reportState : this.jobReport.getJobStateReports()) {
            ArrayList<LogOutput.LogEntry> logsCopy;
            List callsCopy;
            ObservableList<TaskExecution<?>> observableList = reportState.getTaskExecutions();
            synchronized (observableList) {
                callsCopy = reportState.getTaskExecutions().stream().filter(Objects::nonNull).flatMap(taskExecution -> taskExecution.getApiCallHistory().stream()).map(this.cache::getApiCallDetails).filter(Objects::nonNull).collect(Collectors.toList());
            }
            observableList = reportState.getLogLines();
            synchronized (observableList) {
                logsCopy = new ArrayList<LogOutput.LogEntry>((Collection<LogOutput.LogEntry>)reportState.getLogLines());
            }
            StitchingJobReportWriter.writeGroup((HtmlCanvas)html, (int)index++, (LogOutput.TestResultState)StitchingJobReportWriter.convertExperimentTaskStatus(reportState.getFinalStatus()), (String)(reportState.getStateName() + " calls"), (String)("Executed tasks: " + reportState.getTaskExecutions().stream().map(TaskExecution::getName).collect(Collectors.joining(", "))), (long)Duration.between(reportState.getStartTime(), reportState.getEndTime() != null ? reportState.getEndTime() : Instant.now()).toMillis(), (Date)Date.from(reportState.getStartTime()), (Date)Date.from(reportState.getEndTime()), (String)null, callsCopy, logsCopy);
        }
    }

    private static LogOutput.TestResultState convertExperimentTaskStatus(ExperimentTaskStatus status) {
        switch (status) {
            case SUCCESS: {
                return LogOutput.TestResultState.SUCCESS;
            }
            case FAILED: {
                return LogOutput.TestResultState.FAILED;
            }
            case WARNING: {
                return LogOutput.TestResultState.WARN;
            }
        }
        return null;
    }
}

