/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.StatusTask;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;

public class UpdateSfaExperimentPartStateSlice
extends ExperimentPartStateSlice<SfaExperimentPart> {
    private final HighLevelTaskFactory hltf;

    public UpdateSfaExperimentPartStateSlice(Job<?> job, SfaExperimentPart experimentPart, HighLevelTaskFactory hltf) {
        super(job, experimentPart);
        this.hltf = hltf;
    }

    @Override
    public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
        assert (this.experiment.getSliceOrNull() != null);
        this.setAndRunState(new UpdateExperimentPartState(this.experiment, this.hltf, (SfaExperimentPart)this.experimentPart));
        StatusDetails.SliverStatus combinedStatus = ((SfaExperimentPart)this.experimentPart).getSlivers().stream().map(sliver -> sliver.getStatus().getGlobalStatus()).reduce(StatusDetails.SliverStatus.READY, StatusDetails.SliverStatus::merge);
        ((SfaExperimentPart)this.experimentPart).setState(UpdateSfaExperimentPartStateSlice.sliverStatusToInternalState(combinedStatus));
        return combinedStatus != StatusDetails.SliverStatus.FAIL ? ExperimentTaskStatus.SUCCESS : ExperimentTaskStatus.FAILED;
    }

    private static InternalState sliverStatusToInternalState(StatusDetails.SliverStatus sliverStatus) {
        switch (sliverStatus) {
            case READY: {
                return InternalState.READY;
            }
            case FAIL: {
                return InternalState.FAILED;
            }
            case CHANGING: {
                return InternalState.CHANGING;
            }
            case NOTREADY: {
                return InternalState.PROVISIONING;
            }
            case UNALLOCATED: {
                return InternalState.UNALLOCATED;
            }
            case UNINITIALISED: 
            case UNKNOWN: {
                return InternalState.UNKNOWN;
            }
        }
        throw new IllegalArgumentException("Unexpected SliverStatus: " + String.valueOf(sliverStatus));
    }

    public static class UpdateExperimentPartState
    extends SingleCallState<StatusTask> {
        public UpdateExperimentPartState(Experiment experiment, HighLevelTaskFactory hltf, SfaExperimentPart experimentPart) {
            super(String.format("Updating experiment status on %s", experimentPart.getName()), hltf.status(experiment.getSlice(), experimentPart.getConnectSfaAuthority()));
        }
    }
}

