/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.UpdateUntilReadyStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.jobs.states.UpdateUntilFinalOpStateTaskState;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.time.Duration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSfaExperimentPartUntilTargetOpStatusSlice
extends UpdateUntilReadyStateSlice<SfaExperimentPart> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(UpdateSfaExperimentPartUntilTargetOpStatusSlice.class);
    private final Logger LOG;
    @Nonnull
    private final JobStateFactory jobStateFactory;
    @Nonnull
    private final DesiredStatus desiredStatus;
    private boolean timeout;

    public UpdateSfaExperimentPartUntilTargetOpStatusSlice(@Nonnull Job<?> job, @Nonnull SfaExperimentPart experimentPart, @Nullable Duration checkReadyInterval, @Nullable Duration waitForReadyDelay, @Nonnull JobStateFactory jobStateFactory, @Nonnull DesiredStatus desiredStatus) {
        super(job, experimentPart, checkReadyInterval, waitForReadyDelay);
        this.jobStateFactory = jobStateFactory;
        this.desiredStatus = desiredStatus;
        this.timeout = false;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
    }

    @Override
    public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
        UpdateUntilFinalOpStateTaskState statusState = this.jobStateFactory.createGetStatusUntilReadyOrFailTaskState(this.job, this.LOG, this.checkReadyInterval, this.waitForReadyDelay, (SfaExperimentPart)this.experimentPart, this.desiredStatus);
        statusState.setCheckReadyInterval(this.checkReadyInterval);
        this.setAndRunState(statusState);
        this.timeout = statusState.isFailedDueToTimeout();
        if (this.timeout) {
            this.LOG.debug("UpdateSfaExperimentPartUntilTargetOpStatusSlice detected timeout");
        }
        return statusState.getStatus();
    }

    public boolean isTimeout() {
        return this.timeout;
    }
}

