/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.states.CreateUserSpecListState;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.UserSpecHelper;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.PEMUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleKeyState
extends SlicedState<AnsibleKeyStateSlice> {
    private static final Logger LOG = LoggerFactory.getLogger(AnsibleKeyState.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Nonnull
    private final Provider<SfaModel> sfaModelProvider;
    @Nonnull
    private final Provider<ExperimentPartControllerManager> epcManagerProvider;
    private final SetupSoftwareExperimentJob job;
    private final Experiment experiment;
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final List<AnsibleKeyStateSlice> slices;

    protected AnsibleKeyState(SetupSoftwareExperimentJob job, GeniUserProvider geniUserProvider, Provider<SfaModel> sfaModelProvider, Provider<ExperimentPartControllerManager> epcManagerProvider) {
        super("Managing SSH key for ansible");
        this.job = job;
        this.experiment = job.getExperiment();
        this.geniUserProvider = geniUserProvider;
        this.sfaModelProvider = sfaModelProvider;
        this.epcManagerProvider = epcManagerProvider;
        this.experiment.requireSlice();
        this.slices = Collections.singletonList(new AnsibleKeyStateSlice(job));
    }

    @Override
    public Collection<AnsibleKeyStateSlice> getSlices() {
        return this.slices;
    }

    public class AnsibleKeyStateSlice
    extends StateSlice {
        @Nonnull
        protected final SetupSoftwareExperimentJob setupSoftwareExperimentJob;

        public AnsibleKeyStateSlice(SetupSoftwareExperimentJob job) {
            super(job);
            this.setupSoftwareExperimentJob = job;
        }

        @Override
        public String getName() {
            return "Managing ansible SSH key";
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            List<UserSpec> userSpecs = UserSpecHelper.getMergedUserSpecs(AnsibleKeyState.this.geniUserProvider, (SfaModel)AnsibleKeyState.this.sfaModelProvider.get(), (ModelRspec)this.experiment.getSlice().getRequestRspec().getImmutableModelRspec());
            LOG.debug("Experiment has these userSpecs before AnsibleKeyStateSlice.statefulRun: " + userSpecs.stream().map(Object::toString).collect(Collectors.joining(" | ")));
            File keyPairFile = new File(JFedUtils.getUserDataDirectoryFile(), "ansible-cached-keypair-" + this.experiment.getSlice().getUuid() + ".pem");
            if (this.experiment.getKeypairs().isEmpty()) {
                boolean loadedKey = false;
                if (keyPairFile.exists()) {
                    try {
                        GeniUser user = AnsibleKeyState.this.geniUserProvider.getLoggedInGeniUser();
                        BasicDistributeSshKeypair bdsk = new BasicDistributeSshKeypair(null, user.getUserUrn());
                        PEMUtil.PEM pem = PEMUtil.extractPEM((String)IOUtils.fileToString((File)keyPairFile));
                        KeyPair keyPair = pem.getKeyPair();
                        this.experiment.getKeypairs().put((Object)bdsk, (Object)keyPair);
                        userSpecs = UserSpecHelper.addUserSpec(userSpecs, new UserSpec(user.getUserUrn(), pem.toPublicKeyConvertor().withComment("ansible-key").getOpensshFormString()));
                        this.experiment.updateUserSpecs(userSpecs);
                        loadedKey = true;
                        LOG.debug("Loaded ansible key from \"" + keyPairFile.getPath() + "\"");
                        LOG.debug("Experiment has these userSpecs after loading ansible key: " + userSpecs.stream().map(Object::toString).collect(Collectors.joining(" | ")));
                    }
                    catch (PEMUtil.PEMDecodingException | IOException e) {
                        loadedKey = false;
                        LOG.error("Failed to load ansible key from \"" + keyPairFile.getPath() + "\". Will ignore and continue.", e);
                    }
                }
                if (!loadedKey) {
                    LOG.debug("Generating ansible key");
                    CreateUserSpecListState createUserSpecListState = new CreateUserSpecListState(this.experiment, AnsibleKeyState.this.geniUserProvider, (SfaModel)AnsibleKeyState.this.sfaModelProvider.get());
                    this.setAndRunState(createUserSpecListState);
                    userSpecs = createUserSpecListState.getUserSpecs();
                    this.experiment.updateUserSpecs(userSpecs);
                    LOG.debug("Experiment has these userSpecs after generating ansible key: " + userSpecs.stream().map(Object::toString).collect(Collectors.joining(" | ")));
                }
                LOG.debug("Setting ansible key on nodes...");
                this.setAndRunState(new AddAnsibleSshKey(this.experiment, (ExperimentPartControllerManager)AnsibleKeyState.this.epcManagerProvider.get(), userSpecs));
            }
            try {
                KeyPair ansibleKeyPair = (KeyPair)this.experiment.getKeypairs().values().iterator().next();
                String pem = new String(KeyUtil.privateKeyToAnyPem((PrivateKey)ansibleKeyPair.getPrivate()));
                IOUtils.stringToFile((File)keyPairFile, (String)pem);
                LOG.debug("Saved ansible key to \"" + keyPairFile.getPath() + "\"");
            }
            catch (Exception e) {
                LOG.error("Failed to save ansible key to \"" + keyPairFile.getPath() + "\". Will ignore and continue.", (Throwable)e);
            }
            return ExperimentTaskStatus.SUCCESS;
        }

        public class AddAnsibleSshKey
        extends ExperimentPartsSlicedState<ExperimentPartStateSlice<SfaExperimentPart>> {
            private final List<UserSpec> userSpecs;

            public AddAnsibleSshKey(Experiment experiment, ExperimentPartControllerManager manager, List<UserSpec> userSpecs) {
                super("Add Ansible SSH key to nodes", experiment, manager);
                this.userSpecs = userSpecs;
            }

            @Override
            public <EP extends ExperimentPart> ExperimentPartStateSlice createJobSlice(ExperimentPartController<EP> controller, EP experimentPart) {
                return controller.editSshKeys(AnsibleKeyStateSlice.this.job, experimentPart, this.userSpecs);
            }
        }
    }
}

