/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.PlanetlabSfaRegistryInterface;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlanetlabSfaRegistryInterfaceListener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(PlanetlabSfaRegistryInterfaceListener.class);
    private final ParameterHistoryModel parameterHistoryModel;

    public PlanetlabSfaRegistryInterfaceListener(SfaModel sfaModel, ParameterHistoryModel parameterHistoryModel) {
        super(sfaModel);
        this.parameterHistoryModel = parameterHistoryModel;
    }

    private void seeUserCredential(AnyCredential credential) {
        if (credential instanceof SfaCredential) {
            GeniUrn u;
            SfaCredential c = (SfaCredential)credential;
            if (c.getTargetUrn() != null && (u = GeniUrn.parse((String)c.getTargetUrn())) != null && Objects.equals(u.getEncodedResourceType(), "user")) {
                this.seeUserUrn(u);
            }
            if (c.getOwnerUrn() != null && (u = GeniUrn.parse((String)c.getOwnerUrn())) != null) {
                this.seeUserUrn(u);
            }
        }
    }

    private void seeSliceCredential(@Nonnull String serverUrnString, @Nonnull AnyCredential credential) {
        if (credential instanceof SfaCredential) {
            SfaCredential c = (SfaCredential)credential;
            String sliceUrnStr = c.getTargetUrn();
            assert (sliceUrnStr != null);
            try {
                Slice slice = this.getModel().logExistSliceUrn(serverUrnString, sliceUrnStr);
                slice.setCredentials(Collections.singletonList(credential));
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Got an invalid slice-urn {} in credential", (Object)sliceUrnStr, (Object)e);
            }
            catch (JFedHighLevelException e) {
                LOG.error("Could not register slice credential {}", (Object)credential, (Object)e);
            }
        }
    }

    private void seeUserUrn(GeniUrn urn) {
    }

    private void onGetCredentialResult(ApiCallDetails result) {
        LOG.trace("PlanetlabSfaRegistryInterfaceListener.onGetCredentialResult called.");
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            SfaCredential sc;
            GeniUrn target;
            String type;
            AnyCredential anyCredential = (AnyCredential)result.getReply().getValue();
            String string = type = result.getMethodParameters().containsKey("type") ? null : (String)result.getMethodParameters().get("type");
            if (anyCredential instanceof SfaCredential && (target = GeniUrn.parse((String)(sc = (SfaCredential)anyCredential).getTargetUrn())) != null && type == null) {
                type = target.getEncodedResourceType();
            }
            boolean knownType = false;
            if (type != null && (type.equals("user") || type.equals("authority"))) {
                this.parameterHistoryModel.addUserCredential(anyCredential);
                knownType = true;
                this.seeUserCredential(anyCredential);
            }
            if (Objects.equals(type, "slice")) {
                this.parameterHistoryModel.addSliceCredential(anyCredential);
                knownType = true;
                this.seeSliceCredential(result.getServerUrnString(), anyCredential);
            }
            if (!knownType) {
                LOG.warn("Unknown credential type passed to PlanetlabSfaRegistryInterfaceListener.onGetCredentialResult: \"" + type + "\". Adding as both slice and user credential.");
                this.parameterHistoryModel.addUserCredential(anyCredential);
                this.parameterHistoryModel.addSliceCredential(anyCredential);
            }
        }
    }

    private void onGetSelfCredentialResult(ApiCallDetails result) {
        LOG.trace("PlanetlabSfaRegistryInterfaceListener.onGetSelfCredentialResult called.");
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            AnyCredential userCredential = (AnyCredential)result.getReply().getValue();
            LOG.trace("PlanetlabSfaRegistryInterfaceListener.onGetSelfCredentialResult sets user credential.");
            this.getModel().setUserCredentials(Collections.singletonList(userCredential));
            this.seeUserCredential(userCredential);
        }
    }

    private void onRegister(ApiCallDetails result) {
        LOG.trace("PlanetlabSfaRegistryInterfaceListener.onRegister called.");
        String type = (String)((Map)((List)result.getXmlRpcRequest()).get(0)).get("type");
        assert (type != null);
        if (!Objects.equals(type, "slice")) {
            return;
        }
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            String hrn = (String)result.getMethodParameters().get("hrn");
            assert (hrn != null) : "result was not called with hrn parameter. javaMethod=" + result.getJavaMethodName() + " call=" + result.getGeniMethodName();
            GeniUrn sliceUrn = PlanetlabSfaRegistryInterface.sfaHrnToUrn((String)hrn, (String)"slice");
            LOG.debug("PlanetlabSfaRegistryInterfaceListener.onRegister registers slice " + String.valueOf(sliceUrn));
            this.getModel().logExistSliceUrn(result.getServerUrnString(), sliceUrn);
        }
    }

    private void onResolve(ApiCallDetails result) {
        LOG.trace("PlanetlabSfaRegistryInterfaceListener.onRegister called.");
        String xrn = (String)result.getMethodParameters().get("xrn");
        assert (xrn != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            Object regSlicesO;
            String[] parts;
            Map struct = (Map)result.getReply().getValue();
            Object classtypeO = struct.get("classtype");
            if (classtypeO != null && classtypeO instanceof String && Objects.equals(classtypeO, "user")) {
                Object regPiAuths = struct.get("reg-pi-authorities");
                if (regPiAuths != null && regPiAuths instanceof List) {
                    List regPiAuthsList = (List)regPiAuths;
                    LOG.debug("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve processing " + String.valueOf(regPiAuthsList));
                    for (String regPiAuthName : regPiAuthsList) {
                        parts = regPiAuthName.split(Pattern.quote("."));
                        if (parts.length > 1) {
                            this.getModel().addLoggedInUserSubAuthorityName(regPiAuthName);
                            continue;
                        }
                        if (parts.length > 0) continue;
                        LOG.warn("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve reply error: parts.length=" + parts.length + " for regSliceHrn=" + regPiAuthName);
                    }
                } else {
                    LOG.warn("PlanetlabSfaRegistryInterface getSubAuthorityNames Resolve reply error: no reg-pi-authorities or not List: " + String.valueOf(regPiAuths));
                }
            }
            if (classtypeO == null || !(classtypeO instanceof String) || Objects.equals(classtypeO, "slice")) {
                // empty if block
            }
            if (classtypeO == null || !(classtypeO instanceof String) || Objects.equals(classtypeO, "authority")) {
                // empty if block
            }
            if ((regSlicesO = struct.get("reg-slices")) != null && regSlicesO instanceof List) {
                List regSlicesList = (List)regSlicesO;
                for (String regSliceHrn : regSlicesList) {
                    parts = regSliceHrn.split(Pattern.quote("."));
                    if (parts.length >= 2) {
                        GeniUrn sliceUrn = PlanetlabSfaRegistryInterface.sfaHrnToUrn((String)regSliceHrn, (String)"slice");
                        this.getModel().logExistSliceUrn(result.getServerUrnString(), sliceUrn);
                        continue;
                    }
                    LOG.warn("PlanetlabSfaRegistryInterface Resolve reply error: parts.length=" + parts.length + " for regSliceHrn=" + regSliceHrn);
                }
            } else {
                LOG.warn("PlanetlabSfaRegistryInterface Resolve reply error: no reg-slices or not List: " + String.valueOf(regSlicesO));
            }
        }
    }

    public void onResult(ApiCallDetails details) {
        assert (Platform.isFxApplicationThread());
        this.onResultInJavaFXThread(details);
    }

    public void onResultInJavaFXThread(ApiCallDetails result) {
        LOG.trace("PlanetlabSfaRegistryInterfaceListener.onResultInJavaFXThread called. api=" + result.getApiName());
        if (result.getReply() == null || result.getJavaMethodName() == null) {
            return;
        }
        if (!Objects.equals(result.getApiName(), PlanetlabSfaRegistryInterface.getApiName())) {
            return;
        }
        try {
            LOG.trace("PlanetlabSfaRegistryInterfaceListener.onResultInJavaFXThread called for " + result.getJavaMethodName());
            if (Objects.equals(result.getJavaMethodName(), "getCredential")) {
                this.onGetCredentialResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "getSelfCredential")) {
                this.onGetSelfCredentialResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "getSelfCredential_AutomaticArguments")) {
                this.onGetSelfCredentialResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "register")) {
                this.onRegister(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "registerSlice")) {
                this.onRegister(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "resolve")) {
                this.onResolve(result);
            }
        }
        catch (Exception e) {
            LOG.warn("WARNING: Exception when processing PlanetlabSfaRegistryInterface reply for SfaModel. This will be ignored, but it is most likely a bug. message: " + e.getMessage(), (Throwable)e);
        }
    }
}

