/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniResponseCode;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceUrn;
import be.iminds.ilabt.jfed.rspec.model.ManifestSliverFinder;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SfaModelAbstractListener
implements ResultListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaModelAbstractListener.class);
    protected final SfaModel sfaModel;

    public SfaModelAbstractListener(SfaModel sfaModel) {
        this.sfaModel = sfaModel;
    }

    protected SfaModel getModel() {
        return this.sfaModel;
    }

    protected void deriveSliceExistence(@Nonnull GeniUrn sliceId, @Nonnull GeniResponseCode geniResponseCode, @Nonnull Integer serverId) {
        this.deriveSliceExistence(sliceId, geniResponseCode, this.sfaModel.getTestbedInfoSource().getServerById(serverId));
    }

    protected void deriveSliceExistence(@Nonnull GeniUrn sliceId, @Nonnull GeniResponseCode geniResponseCode, @Nonnull Server authority) {
        if (Objects.equals(geniResponseCode, GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
            this.getModel().logNotExistSliverInSliceOnAuth(sliceId, authority);
        } else if (geniResponseCode.isSuccess()) {
            this.getModel().logExistSlice(sliceId);
        }
    }

    protected void noteUserCredentialInParameters(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            List userCredentials;
            AnyCredential userCredential;
            if (result.getMethodParameters().containsKey("userCredential") && (userCredential = (AnyCredential)result.getMethodParameters().get("userCredential")) != null) {
                ArrayList<AnyCredential> credentialList = new ArrayList<AnyCredential>();
                credentialList.add(userCredential);
                this.getModel().setUserCredentials(credentialList);
            }
            if (result.getMethodParameters().containsKey("credentialList") && (userCredentials = (List)result.getMethodParameters().get("credentialList")) != null && userCredentials.size() > 0) {
                this.getModel().setUserCredentials(userCredentials);
            }
        }
    }

    protected ResourceId noteSliceCredentialInParameters(ApiCallDetails result) {
        assert (result.getReply() != null);
        AnyCredential sliceCredential = (AnyCredential)result.getMethodParameters().get("sliceCredential");
        if (sliceCredential instanceof SfaCredential) {
            String sliceUrn = ((SfaCredential)sliceCredential).getTargetUrn();
            try {
                Slice slice;
                GeniUrn sliceId = new GeniUrn(sliceUrn);
                this.deriveSliceExistence(sliceId, result.getReply().getGeniResponseCode(), result.getServerId());
                if (result.getReply().getGeniResponseCode().isSuccess() && !(slice = this.getModel().getSlice(sliceId)).hasCredential()) {
                    try {
                        slice.setCredentials(Collections.singletonList(sliceCredential));
                    }
                    catch (JFedHighLevelException e) {
                        LOG.error("Error while registering slice credential '{}'", (Object)sliceCredential, (Object)e);
                    }
                    this.noteSliceExpirationInSliceCredential(slice, sliceCredential);
                }
                return sliceId;
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not process slice credential because of an invalid urn {}", (Object)sliceUrn, (Object)e);
                return new ResourceUrn(sliceUrn);
            }
        }
        return null;
    }

    protected void noteSliceExpirationInSliceCredential(Slice slice, AnyCredential sliceCredential) {
        SfaCredential sfaSliceCredential;
        Instant expiresDate;
        if (sliceCredential instanceof SfaCredential && (expiresDate = (sfaSliceCredential = (SfaCredential)sliceCredential).getExpiresDate().toInstant()) != null && (slice.getExpirationDate() == null || expiresDate.isAfter(slice.getExpirationDate()))) {
            slice.setExpirationDate(expiresDate);
        }
    }

    protected GeniUrn noteSliceUrnInParameters(ApiCallDetails result) {
        assert (result.getReply() != null);
        GeniUrn id = null;
        if (result.getMethodParameters().get("slice") instanceof GeniUrn) {
            id = (GeniUrn)result.getMethodParameters().get("slice");
        }
        if (result.getMethodParameters().get("sliceUrn") instanceof GeniUrn) {
            id = (GeniUrn)result.getMethodParameters().get("sliceUrn");
        }
        this.deriveSliceExistence(id, result.getReply().getGeniResponseCode(), result.getServerId());
        return id;
    }

    public static List<Sliver> findSliversInManifest(SfaModel sfaModel, Server auth, String sliceUrn, ManifestRspecSource manifestRspecSource) throws GeniUrn.GeniUrnParseException {
        return SfaModelAbstractListener.findSliversInManifest(sfaModel, auth, new GeniUrn(sliceUrn), manifestRspecSource);
    }

    @Nullable
    public static List<Sliver> findSliversInManifest(SfaModel sfaModel, Server auth, GeniUrn sliceUrn, ManifestRspecSource manifestRspecSource) {
        Sliver sliver;
        ArrayList<Sliver> sliverList = new ArrayList<Sliver>();
        HashSet<GeniUrn> seenSlivers = new HashSet<GeniUrn>();
        HashSet<GeniUrn> errorSlivers = new HashSet<GeniUrn>();
        ImmutableModelRspec rspec = manifestRspecSource.getImmutableModelRspec();
        if (rspec == null) {
            return null;
        }
        for (RspecNode node : rspec.getNodes()) {
            if (node.getSliverId() == null) continue;
            sliver = sfaModel.logExistSliver(sliceUrn, node.getSliverId(), auth, Sliver.Source.AGGREGATE_MANAGER_MANIFEST);
            if (sliver != null) {
                if (node.getClientId() != null && node.getComponentId() != null) {
                    sliver.logExistsComponent(node.getClientId(), node.getComponentId().toString());
                } else {
                    LOG.warn("findSliversInManifest: While processing sliver " + String.valueOf(node.getSliverId()) + ", found a node with client_id=" + node.getClientId() + " and component_id=" + String.valueOf(node.getComponentId()));
                }
                if (!seenSlivers.add(sliver.getUrn())) continue;
                sliverList.add(sliver);
                continue;
            }
            LOG.warn("findSliversInManifest: Could not create/find sliver while processing node sliver " + String.valueOf(node.getSliverId()) + ". Something went wrong in sfaModel.logExistSliver. (possibly sliver does not match authority)");
            errorSlivers.add(node.getSliverId());
        }
        for (RspecLink link : rspec.getLinks()) {
            if (link.getSliverId() == null) continue;
            sliver = sfaModel.logExistSliver(sliceUrn, link.getSliverId(), auth, Sliver.Source.AGGREGATE_MANAGER_MANIFEST);
            if (sliver != null) {
                if (!seenSlivers.add(sliver.getUrn())) continue;
                sliverList.add(sliver);
                continue;
            }
            LOG.warn("SfaModelAbstractListener.findSliversInManifest: Could not create/find sliver while processing link sliver " + String.valueOf(link.getSliverId()) + ". Something went wrong in sfaModel.logExistSliver. (possibly sliver does not match authority)");
            errorSlivers.add(link.getSliverId());
        }
        HashSet unSeenSliverUrns = new HashSet(ManifestSliverFinder.findSliversInManifest((ManifestRspecSource)manifestRspecSource));
        unSeenSliverUrns.removeAll(seenSlivers);
        unSeenSliverUrns.removeAll(errorSlivers);
        for (GeniUrn sliverUrn : unSeenSliverUrns) {
            Sliver sliver2 = sfaModel.logExistSliver(sliceUrn, sliverUrn, auth, Sliver.Source.AGGREGATE_MANAGER_MANIFEST);
            if (sliver2 == null) {
                LOG.warn("SfaModelAbstractListener.findSliversInManifest: Could not create/find sliver while processing sliver " + String.valueOf(sliverUrn) + ". Something went wrong in sfaModel.logExistSliver. (possibly sliver does not match authority)");
                continue;
            }
            sliverList.add(sliver2);
        }
        if (sliverList.isEmpty()) {
            return null;
        }
        return sliverList;
    }

    public List<Sliver> findSliversInManifest(Server auth, String sliceUrn, ManifestRspecSource manifestRspecSource) throws GeniUrn.GeniUrnParseException {
        return SfaModelAbstractListener.findSliversInManifest(this.getModel(), auth, sliceUrn, manifestRspecSource);
    }

    @Nonnull
    public List<Sliver> findSliversInManifest(Server auth, GeniUrn sliceUrn, ManifestRspecSource manifestRspecSource) {
        List<Sliver> res = SfaModelAbstractListener.findSliversInManifest(this.getModel(), auth, sliceUrn, manifestRspecSource);
        return Objects.requireNonNullElse(res, Collections.emptyList());
    }
}

