/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.ProtogeniSliceAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.resourceid.ResourceId;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaModelSliceAuthorityListener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaModelSliceAuthorityListener.class);
    private final TestbedInfoSource testbedInfoSource;

    public SfaModelSliceAuthorityListener(SfaModel sfaModel, TestbedInfoSource testbedInfoSource) {
        super(sfaModel);
        this.testbedInfoSource = testbedInfoSource;
    }

    private void onGetVersionResult(ApiCallDetails result) {
        assert (result.getReply() != null);
    }

    private void onGetSliceCredentialResult(ApiCallDetails result) {
        GeniUrn sliceId = this.noteSliceUrnInParameters(result);
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess() && Objects.equals(sliceId.getType(), "urn")) {
            Slice slice;
            String sliceUrn = sliceId.getValue();
            try {
                slice = this.getModel().getSlice(sliceUrn);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not get slice because of invalid URN {}", (Object)sliceUrn, (Object)e);
                return;
            }
            AnyCredential sliceCredential = (AnyCredential)result.getReply().getValue();
            if (sliceCredential != null) {
                if (sliceCredential.getExpiresDate() != null && sliceCredential.getExpiresDate().before(new Date())) {
                    if (slice.getExpirationDate() == null) {
                        this.getModel().logNotExistSlice(slice.getUrn());
                    }
                } else {
                    try {
                        slice.setCredentials(Collections.singletonList(sliceCredential));
                    }
                    catch (JFedHighLevelException e) {
                        LOG.error("Error while registering slice credential '{}'", (Object)sliceCredential, (Object)e);
                    }
                    this.noteSliceExpirationInSliceCredential(slice, sliceCredential);
                }
            } else {
                LOG.warn("SfaModelSliceAuthorityListener.onGetSliceCredentialResult -> sliceCredential in result is null");
            }
        }
    }

    private void seeUrn(String urnStr) {
        GeniUrn urn = GeniUrn.parse((String)urnStr);
        if (urn != null) {
            this.seeUrn(urn);
        }
    }

    private void seeUrn(GeniUrn urn) {
        String subAuthName = urn.getEncodedSubAuthName();
        if (subAuthName != null) {
            this.getModel().addAnySubAuthorityName(subAuthName);
        }
    }

    private void onGetCredentialResult(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            AnyCredential userCredential = (AnyCredential)result.getReply().getValue();
            this.getModel().setUserCredentials(Collections.singletonList(userCredential));
        }
    }

    private void onResolveSliceResult(ApiCallDetails result) throws JFedException {
        GeniUrn sliceId = this.noteSliceUrnInParameters(result);
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            if (Objects.equals(sliceId.getType(), "urn")) {
                ProtogeniSliceAuthority.SliceInfo sliceInfo = (ProtogeniSliceAuthority.SliceInfo)result.getReply().getValue();
                Slice slice = this.getModel().getSlice(sliceId);
                assert (slice != null);
                if (!Objects.equals(sliceInfo.getSliceUrn(), sliceId)) {
                    throw new JFedException("URN in Resolve answer (\"" + String.valueOf(sliceInfo.getSliceUrn()) + "\") is NOT the same as urn of slice (\"" + String.valueOf(sliceId) + "\").");
                }
                slice.uuidProperty().setValue(sliceInfo.getUuid());
                slice.creator_uuidProperty().setValue(sliceInfo.getCreatorUuid());
                slice.creator_urnProperty().setValue(sliceInfo.getCreatorUrn().getValue());
                slice.setGid(sliceInfo.getGid());
                for (GeniUrn cmUrn : sliceInfo.getComponentManagers()) {
                    Server auth = this.testbedInfoSource.getByUrn(cmUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_ONLY_EXACT_SUBAUTHORITY, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
                    if (auth == null) continue;
                    this.getModel().logExistAtLeastOneSliver(sliceInfo.getSliceUrn(), auth, Sliver.Source.SLICE_AUTHORITY);
                }
            }
        } else if (Objects.equals(result.getReply().getGeniResponseCode(), GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED)) {
            this.getModel().logNotExistSlice(sliceId);
        }
    }

    private void onResolveUserResult(ApiCallDetails result) {
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            assert (result.getServerId() != null);
            assert (result.getServerUrnString() != null);
            ProtogeniSliceAuthority.UserInfo userInfo = (ProtogeniSliceAuthority.UserInfo)result.getReply().getValue();
            for (GeniUrn geniUrn : userInfo.getSlices()) {
                this.getModel().logExistSliceUrn(result.getServerUrnString(), geniUrn);
            }
            for (Map.Entry entry : userInfo.getSubAuthorities().entrySet()) {
                GeniUrn urn = (GeniUrn)entry.getKey();
                String subAuthName = urn.getEncodedSubAuthName();
                if (subAuthName != null) {
                    this.getModel().addLoggedInUserSubAuthorityName(subAuthName);
                }
                this.seeUrn(urn);
            }
        }
    }

    private void onBindToSliceResult(ApiCallDetails result) {
        this.noteSliceCredentialInParameters(result);
        assert (result.getReply() != null);
    }

    private void onRegisterResult(ApiCallDetails result) {
        assert (result.getReply() != null);
        this.noteUserCredentialInParameters(result);
        GeniUrn sliceId = this.noteSliceUrnInParameters(result);
        if (result.getReply().getGeniResponseCode().isSuccess() && Objects.equals(sliceId.getType(), "urn")) {
            String sliceUrn = sliceId.getValue();
            try {
                Slice slice = this.getModel().getSlice(sliceUrn);
                AnyCredential sliceCredential = (AnyCredential)result.getReply().getValue();
                try {
                    if (sliceCredential != null) {
                        slice.setCredentials(Collections.singletonList(sliceCredential));
                    }
                }
                catch (JFedHighLevelException e) {
                    LOG.error("Error while registering slice credential '{}'", (Object)sliceCredential, (Object)e);
                }
                this.noteSliceExpirationInSliceCredential(slice, sliceCredential);
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not process register result because of an invalid URN {}", (Object)sliceUrn, (Object)e);
            }
        }
    }

    private void onRenewSliceResult(ApiCallDetails result) throws ParseException {
        ResourceId sliceId = this.noteSliceCredentialInParameters(result);
        assert (result.getReply() != null);
        if (sliceId != null && result.getReply().getGeniResponseCode().isSuccess()) {
            String expiration_rfc3339 = (String)result.getMethodParameters().get("expiration_rfc3339");
            String sliceUrn = sliceId.getValue();
            try {
                Slice slice = this.getModel().getSlice(sliceUrn);
                slice.setExpirationDate(RFC3339Util.rfc3339StringToDate((String)expiration_rfc3339).toInstant());
                if (result.getReply().getValue() != null) {
                    AnyCredential newSliceCredential = (AnyCredential)result.getReply().getValue();
                    this.noteSliceExpirationInSliceCredential(slice, newSliceCredential);
                    try {
                        slice.setCredentials(Collections.singletonList(newSliceCredential));
                    }
                    catch (JFedHighLevelException e) {
                        LOG.error("Error while registering slice credentials '{}'", (Object)newSliceCredential, (Object)e);
                    }
                }
            }
            catch (GeniUrn.GeniUrnParseException e) {
                LOG.error("Could not process renew result because of an invalid URN {}", (Object)sliceUrn, (Object)e);
            }
        }
    }

    private void onShutdownResult(ApiCallDetails result) {
        ResourceId sliceId = this.noteSliceCredentialInParameters(result);
        assert (result.getReply() != null);
        if (sliceId != null && result.getReply().getGeniResponseCode().isSuccess()) {
            assert (sliceId instanceof GeniUrn);
            this.getModel().logNotExistSlice((GeniUrn)sliceId);
        }
    }

    private void onGetKeysResult(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            List keyStrings = (List)result.getReply().getValue();
            for (Object k : keyStrings) {
                this.getModel().addUserKey((String)k);
            }
        }
    }

    private void onRemoveResult(ApiCallDetails result) {
        ResourceId sliceId = this.noteSliceCredentialInParameters(result);
        assert (result.getReply() != null);
        if (sliceId != null && result.getReply().getGeniResponseCode().isSuccess()) {
            assert (sliceId instanceof GeniUrn);
            this.getModel().logNotExistSlice((GeniUrn)sliceId);
        }
    }

    public void onResult(ApiCallDetails result) {
        assert (Platform.isFxApplicationThread());
        if (result.getReply() == null || result.getJavaMethodName() == null) {
            return;
        }
        if (!Objects.equals(result.getApiName(), ProtogeniSliceAuthority.getApiName())) {
            return;
        }
        try {
            if (Objects.equals(result.getJavaMethodName(), "getVersion")) {
                this.onGetVersionResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "getSliceCredential")) {
                this.onGetSliceCredentialResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "getCredential")) {
                this.onGetCredentialResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "resolveSlice")) {
                this.onResolveSliceResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "resolveUser")) {
                this.onResolveUserResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "bindToSlice")) {
                this.onBindToSliceResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "register")) {
                this.onRegisterResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "renewSlice")) {
                this.onRenewSliceResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "shutdown")) {
                this.onShutdownResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "getKeys")) {
                this.onGetKeysResult(result);
            }
            if (Objects.equals(result.getJavaMethodName(), "remove")) {
                this.onRemoveResult(result);
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when processing SliceAuthority reply for SfaModel. This will be ignored, but it is most likely a bug. ", (Throwable)e);
        }
    }
}

