/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.highlevel.model.ParameterHistoryModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationMemberAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import java.security.PublicKey;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaUniformFederationMemberAuthorityApiListener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaUniformFederationMemberAuthorityApiListener.class);
    private final GeniUserProvider geniUserProvider;

    public SfaUniformFederationMemberAuthorityApiListener(SfaModel sfaModel, GeniUserProvider geniUserProvider) {
        super(sfaModel);
        this.geniUserProvider = geniUserProvider;
    }

    private void onGetCredentials(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            GeniUrn memberUrn = (GeniUrn)result.getMethodParameters().get("memberUrn");
            assert (memberUrn != null);
            assert (result.getReply().getValue() instanceof List);
            List userCredentials = (List)result.getReply().getValue();
            if (userCredentials != null && userCredentials.size() > 0) {
                if (this.geniUserProvider != null && this.geniUserProvider.isUserLoggedIn() && Objects.equals(memberUrn, this.geniUserProvider.getLoggedInGeniUser().getUserUrn())) {
                    this.getModel().setUserCredentials(userCredentials);
                } else {
                    LOG.warn("Credentials are not for user, adding them only to parameterHistoryModel.");
                    ParameterHistoryModel parameterHistoryModel = this.getModel().getParameterHistoryModel();
                    userCredentials.forEach(parameterHistoryModel::addUserCredential);
                }
                if (userCredentials.size() > 1) {
                    LOG.warn("TODO: The Federation API MA returned multiple credentials, but this is not yet supported by jFed");
                }
            }
        }
    }

    private void onLookupKeysApi1(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            Map lookupResult = (Map)result.getReply().getValue();
            for (Map.Entry entry : lookupResult.entrySet()) {
                List keyInfoList = (List)entry.getValue();
                for (AbstractFederationApi.MemberKeyInfo memberKeyInfo : keyInfoList) {
                    this.getModel().addUserKey((GeniUrn)entry.getKey(), memberKeyInfo.getPublicKey());
                }
            }
        }
    }

    private void onLookupKeysApi2(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.MemberKeyInfoList lookupResult = (AbstractFederationApi.MemberKeyInfoList)result.getReply().getValue();
            for (Map.Entry entry : lookupResult.entrySet()) {
                AbstractFederationApi.MemberKeyInfo keyInfo = (AbstractFederationApi.MemberKeyInfo)entry.getValue();
                if (keyInfo.getPublicKey() == null || keyInfo.getKeyMember() == null) continue;
                this.getModel().addUserKey((GeniUrn)entry.getKey(), keyInfo.getPublicKey());
            }
        }
    }

    private void onLookupMember2(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply().getGeniResponseCode().isSuccess() && result.getReply().getValue() != null && result.getReply().getValue() instanceof AbstractFederationApi.MemberInfoList) {
            AbstractFederationApi.MemberInfoList lookupResult = (AbstractFederationApi.MemberInfoList)result.getReply().getValue();
            if (lookupResult == null || lookupResult.size() != 1 || ((AbstractFederationApi.MemberInfo)lookupResult.values().iterator().next()).getX509pemCerts() == null) {
                return;
            }
            List certs = ((AbstractFederationApi.MemberInfo)lookupResult.values().iterator().next()).getX509pemCerts();
            block2: for (X509Certificate cert : certs) {
                try {
                    Collection<List<?>> altNames = cert.getSubjectAlternativeNames();
                    for (List<?> altName : altNames) {
                        Integer nameType = (Integer)altName.get(0);
                        String altKey = altName.get(1).toString();
                        if (!altKey.contains("+user+")) continue;
                        GeniUrn memberUrn = GeniUrn.parse((String)altKey);
                        if (memberUrn == null) continue block2;
                        this.getModel().addUserKey(memberUrn, PublicKeyConvertor.fromPublicKey((PublicKey)cert.getPublicKey()).withComment(altKey).getOpensshFormString());
                    }
                }
                catch (CertificateParsingException ignored) {
                    LOG.debug("Error parsing certificate received in lookup MEMBER \"_GENI_MEMBER_SSL_CERTIFICATE\" field. Will ignore certificate.");
                }
            }
        }
    }

    public void onResult(ApiCallDetails details) {
        assert (Platform.isFxApplicationThread());
        this.onResultInJavaFXThread(details);
    }

    public void onResultInJavaFXThread(ApiCallDetails result) {
        if (result.getReply() == null || result.getJavaMethodName() == null) {
            return;
        }
        if (!Objects.equals(result.getApiName(), FederationMemberAuthorityApi1.getApiName()) && !Objects.equals(result.getApiName(), FederationMemberAuthorityApi2.getApiName())) {
            return;
        }
        try {
            if (Objects.equals(result.getApiName(), FederationMemberAuthorityApi1.getApiName())) {
                if (Objects.equals(result.getJavaMethodName(), "lookupKeys")) {
                    this.onLookupKeysApi1(result);
                }
                if (Objects.equals(result.getJavaMethodName(), "getCredentials")) {
                    this.onGetCredentials(result);
                }
            }
            if (Objects.equals(result.getApiName(), FederationMemberAuthorityApi2.getApiName())) {
                if (result.getReply().getValue() instanceof AbstractFederationApi.MemberKeyInfoList) {
                    this.onLookupKeysApi2(result);
                }
                if (result.getReply().getValue() instanceof AbstractFederationApi.MemberInfoList) {
                    this.onLookupMember2(result);
                }
                if (Objects.equals(result.getJavaMethodName(), "getCredentials")) {
                    this.onGetCredentials(result);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when processing SliceAuthority reply for SfaModel. This will be ignored, but it is most likely a bug. ", (Throwable)e);
        }
    }
}

