/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.model;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractFederationApi;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi1;
import be.iminds.ilabt.jfed.lowlevel.api.FederationSliceAuthorityApi2;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.lib.GeniUniformFederationApiResponseCode;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SfaUniformFederationSliceAuthorityApiListener
extends SfaModelAbstractListener {
    private static final Logger LOG = LoggerFactory.getLogger(SfaUniformFederationSliceAuthorityApiListener.class);
    private final TestbedInfoSource testbedInfoSource;

    public SfaUniformFederationSliceAuthorityApiListener(SfaModel sfaModel, TestbedInfoSource testbedInfoSource) {
        super(sfaModel);
        this.testbedInfoSource = testbedInfoSource;
    }

    private void onGetSliceCredentials(ApiCallDetails result) {
        block9: {
            assert (result.getReply() != null);
            GeniUrn sliceId = this.noteSliceUrnInParameters(result);
            assert (sliceId != null);
            this.noteUserCredentialInParameters(result);
            if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
                String sliceUrn = sliceId.getValue();
                try {
                    Slice slice = this.getModel().getSlice(sliceUrn);
                    List credentialList = (List)result.getReply().getValue();
                    if (credentialList != null) {
                        if (credentialList.size() > 0) {
                            try {
                                slice.setCredentials(credentialList);
                            }
                            catch (JFedHighLevelException e) {
                                LOG.error("Error while registering slice credentials {}", (Object)credentialList, (Object)e);
                            }
                        }
                        credentialList.stream().filter(credential -> credential instanceof SfaCredential).filter(credential -> slice.getExpirationDate() == null || credential.getExpiresDate().toInstant().isAfter(slice.getExpirationDate())).forEach(credential -> slice.setExpirationDate(credential.getExpiresDate().toInstant()));
                        break block9;
                    }
                    LOG.warn("Received an empty credential list for {}", (Object)sliceUrn);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    LOG.error("Cannot process GetSliceCredential because of an invalid sliceUrn {}", (Object)sliceUrn);
                }
            }
        }
    }

    private void onLookupSliceInfoResult(ApiCallDetails result) {
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            assert (result.getReply().getValue() instanceof AbstractFederationApi.SliceInfoList);
            AbstractFederationApi.SliceInfoList lookupRes = (AbstractFederationApi.SliceInfoList)result.getReply().getValue();
            if (lookupRes != null) {
                for (Map.Entry entry : lookupRes.entrySet()) {
                    AbstractFederationApi.SliceInfo sliceInfo = (AbstractFederationApi.SliceInfo)entry.getValue();
                    Slice slice = this.getModel().logExistSlice(sliceInfo.getSliceUrn());
                    if (sliceInfo.getExpirationDate() != null) {
                        slice.setExpirationDate(sliceInfo.getExpirationDate().toInstant());
                    }
                    if (sliceInfo.getEmulabHasSlivers() != null) {
                        slice.setHasActiveSlivers(sliceInfo.getEmulabHasSlivers());
                    }
                    slice.setUuid(sliceInfo.getUuid());
                    if (sliceInfo.getCreationDate() == null) continue;
                    slice.setCreationDate(sliceInfo.getCreationDate().toInstant());
                }
            }
        }
    }

    private void onLookupProjectResult(ApiCallDetails result) {
        LOG.debug("onLookupProjectResult ");
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.ProjectInfoMap projectInfoMap;
            Object v = result.getReply().getValue();
            LOG.debug("onLookupProjectResult type=" + String.valueOf(v.getClass()));
            if (v instanceof AbstractFederationApi.ProjectInfoMap && (projectInfoMap = (AbstractFederationApi.ProjectInfoMap)v) != null) {
                projectInfoMap.forEach((u, pi) -> {
                    if (!pi.getExpired().booleanValue() && pi.getProjectUrn() != null && pi.getExpirationDate() != null) {
                        this.getModel().getProjectExpirations().put((Object)pi.getProjectUrn(), (Object)pi.getExpirationDate().toInstant());
                        LOG.debug("onLookupProjectResult Registered project " + String.valueOf(pi.getProjectUrn()) + " expiration: " + String.valueOf(pi.getExpirationDate()));
                    } else {
                        LOG.debug("onLookupProjectResult Not registered project " + String.valueOf(pi.getProjectUrn()) + " expiration: " + String.valueOf(pi.getExpirationDate()));
                    }
                });
            }
            if (v instanceof AbstractFederationApi.ProjectInfoList) {
                AbstractFederationApi.ProjectInfoList projectInfoList = (AbstractFederationApi.ProjectInfoList)v;
                LOG.debug("onLookupProjectResult process ProjectInfoList with size=" + projectInfoList.size());
                if (projectInfoList != null) {
                    projectInfoList.forEach(pi -> {
                        if (!pi.getExpired().booleanValue() && pi.getProjectUrn() != null && pi.getExpirationDate() != null) {
                            this.getModel().getProjectExpirations().put((Object)pi.getProjectUrn(), (Object)pi.getExpirationDate().toInstant());
                            LOG.debug("onLookupProjectResult Registered project " + String.valueOf(pi.getProjectUrn()) + " expiration: " + String.valueOf(pi.getExpirationDate()));
                        } else {
                            LOG.debug("onLookupProjectResult Not registered project " + String.valueOf(pi.getProjectUrn()) + " expiration: " + String.valueOf(pi.getExpirationDate()));
                        }
                    });
                }
            }
        }
    }

    private List<String> getRequestedSlices(ApiCallDetails result) {
        Object matchObj;
        ArrayList<String> sliceUrns = new ArrayList<String>();
        Object sliceUrnObj = result.getMethodParameters().get("sliceUrn");
        if (sliceUrnObj != null) {
            sliceUrns.add(sliceUrnObj.toString());
        }
        if ((matchObj = result.getMethodParameters().get("match")) instanceof Map) {
            Map match = (Map)matchObj;
            Object sliverInfoSliceUrn = match.get("SLIVER_INFO_SLICE_URN");
            if (sliverInfoSliceUrn instanceof String) {
                sliceUrns.add((String)sliverInfoSliceUrn);
            } else if (sliverInfoSliceUrn instanceof List) {
                List urns = (List)sliverInfoSliceUrn;
                sliceUrns.addAll(urns);
            } else {
                LOG.error("Unexpected value type: {}", (Object)sliverInfoSliceUrn.getClass().getName());
            }
        }
        if (sliceUrns.isEmpty()) {
            LOG.warn("Could not derive sliceUrns from request parameters");
        }
        return sliceUrns;
    }

    private void onLookupSliverInfoResult(ApiCallDetails result) throws JFedException {
        block10: {
            block9: {
                this.noteUserCredentialInParameters(result);
                assert (result.getReply() != null);
                if (result.getReply() == null || !result.getReply().getGeniResponseCode().isSuccess()) break block9;
                AbstractFederationApi.SliverInfoList lookupRes = (AbstractFederationApi.SliverInfoList)result.getReply().getValue();
                if (lookupRes == null) break block10;
                lookupRes.values().stream().map(AbstractFederationApi.SliverInfo::getSliceUrn).forEach(sliceUrn -> {
                    Slice slice = this.getModel().getSlice((GeniUrn)sliceUrn);
                    slice.setHasActiveSlivers(true);
                });
                for (AbstractFederationApi.SliverInfo sliverInfo : lookupRes.values()) {
                    Server auth = this.testbedInfoSource.getByUrn(sliverInfo.getAggregateUrn(), TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
                    if (auth == null) {
                        LOG.warn("Unknown aggregate returned in SliverInfo: {}", (Object)sliverInfo.getAggregateUrn());
                        continue;
                    }
                    assert (Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), sliverInfo.getAggregateUrn()));
                    if (!Objects.equals(sliverInfo.getSliverUrn().getEncodedTopLevelAuthority_withoutSubAuth(), auth.getDefaultComponentManagerAsGeniUrn().getEncodedTopLevelAuthority_withoutSubAuth())) {
                        LOG.warn("Encountered a mismatch between sliver URN and aggregate URN while processing SliverInfo: amUrn={} vs sliverUrn={}", (Object)sliverInfo.getAggregateUrn(), (Object)sliverInfo.getSliverUrn());
                        continue;
                    }
                    Sliver sliver = this.getModel().logExistSliver(sliverInfo.getSliceUrn(), sliverInfo.getSliverUrn(), auth, Sliver.Source.SLICE_AUTHORITY);
                    if (sliver == null || sliver.getExpirationDate() != null) continue;
                    sliver.setExpirationDate(sliverInfo.getExpirationDate().toInstant());
                }
                break block10;
            }
            if (result.getReply().getGeniResponseCode() == GeniUniformFederationApiResponseCode.SEARCHFAILED) {
                List<String> requestedSlices = this.getRequestedSlices(result);
                for (String requestedSliceStr : requestedSlices) {
                    try {
                        this.getModel().logNotExistSliverInSliceOnAuth(new GeniUrn(requestedSliceStr), result.getServerId());
                    }
                    catch (GeniUrn.GeniUrnParseException e) {
                        LOG.warn("Could not registed slice {} as non-existing on {} because URN could not be parsed", (Object)requestedSliceStr, (Object)result.getServerName());
                    }
                }
            }
        }
    }

    private void onGetSlicesForMember1(ApiCallDetails result) throws JFedException {
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.FederationApiReply reply = (AbstractFederationApi.FederationApiReply)result.getReply();
            if (!reply.getGeniResponseCode().isSuccess() || reply.getValue() == null) {
                return;
            }
            List urnRoleTuples = (List)reply.getValue();
            for (FederationSliceAuthorityApi1.UrnRoleTuple urnRoleTuple2 : urnRoleTuples) {
                String sliceUrnString = urnRoleTuple2.getUrn().getValue();
                try {
                    this.getModel().logExistSlice(sliceUrnString);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    LOG.error("Could not register slice invalid urn {}", (Object)sliceUrnString, (Object)e);
                }
            }
            urnRoleTuples.stream().filter(urnRoleTuple -> !urnRoleTuple.isExpired()).forEach(urnRoleTuple -> {
                String subAuthName = urnRoleTuple.getUrn().getSubAuthName();
                if (subAuthName != null) {
                    this.getModel().addAnySubAuthorityName(subAuthName);
                }
            });
        }
    }

    private void onGetSlicesForMember2(ApiCallDetails result) throws JFedException {
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.FederationApiReply reply = (AbstractFederationApi.FederationApiReply)result.getReply();
            if (!reply.getGeniResponseCode().isSuccess() || reply.getValue() == null) {
                return;
            }
            List urnRoleTuples = (List)reply.getValue();
            for (FederationSliceAuthorityApi2.UrnRoleTuple urnRoleTuple2 : urnRoleTuples) {
                String sliceUrnString = urnRoleTuple2.getUrn().getValue();
                if (urnRoleTuple2.isExpired()) continue;
                try {
                    this.getModel().logExistSlice(sliceUrnString);
                }
                catch (GeniUrn.GeniUrnParseException e) {
                    LOG.error("Could not register slice invalid urn {}", (Object)sliceUrnString, (Object)e);
                }
            }
            urnRoleTuples.stream().filter(urnRoleTuple -> !urnRoleTuple.isExpired()).forEach(urnRoleTuple -> {
                String subAuthName = urnRoleTuple.getUrn().getSubAuthName();
                if (subAuthName != null) {
                    this.getModel().addAnySubAuthorityName(subAuthName);
                }
            });
        }
    }

    private void onGetProjectsForMember2(ApiCallDetails result) throws JFedException {
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.FederationApiReply reply = (AbstractFederationApi.FederationApiReply)result.getReply();
            if (!reply.getGeniResponseCode().isSuccess() || reply.getValue() == null) {
                return;
            }
            List urnRoleTuples = (List)reply.getValue();
            urnRoleTuples.stream().filter(urnRoleTuple -> !urnRoleTuple.isExpired()).filter(urnRoleTuple -> !Objects.equals(urnRoleTuple.getRole(), "UNKNOWN")).forEach(urnRoleTuple -> {
                String subAuthName = urnRoleTuple.getUrn().getEncodedResourceName();
                if (subAuthName != null) {
                    this.getModel().addLoggedInUserSubAuthorityName(subAuthName);
                }
            });
        }
    }

    private void onGetProjectsForMember1(ApiCallDetails result) throws JFedException {
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess()) {
            AbstractFederationApi.FederationApiReply reply = (AbstractFederationApi.FederationApiReply)result.getReply();
            if (!reply.getGeniResponseCode().isSuccess() || reply.getValue() == null) {
                return;
            }
            List urnRoleTuples = (List)reply.getValue();
            urnRoleTuples.stream().filter(urnRoleTuple -> !urnRoleTuple.isExpired()).forEach(urnRoleTuple -> {
                String subAuthName = urnRoleTuple.getUrn().getEncodedResourceName();
                if (subAuthName != null) {
                    this.getModel().addLoggedInUserSubAuthorityName(subAuthName);
                }
            });
        }
    }

    private void onCreateSlice(ApiCallDetails result) {
        LOG.debug("onCreateSlice -> called");
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess() && result.getReply().getValue() != null) {
            AbstractFederationApi.SliceInfo sliceInfo = (AbstractFederationApi.SliceInfo)result.getReply().getValue();
            Slice slice = this.getModel().logExistSlice(sliceInfo.getSliceUrn());
            slice.setUuid(sliceInfo.getUuid());
            slice.setCreationDate(sliceInfo.getCreationDate() != null ? sliceInfo.getCreationDate().toInstant() : Instant.now());
            slice.setExpirationDate(sliceInfo.getExpirationDate() != null ? sliceInfo.getExpirationDate().toInstant() : null);
        }
    }

    private void onGetSliceMembers(ApiCallDetails result) {
        GeniUrn sliceUrn = (GeniUrn)result.getMethodParameters().get("urn");
        assert (sliceUrn != null);
        assert (result.getReply() != null);
        if (result.getReply() == null) {
            return;
        }
        this.deriveSliceExistence(sliceUrn, result.getReply().getGeniResponseCode(), result.getServerId());
        if (result.getReply().getGeniResponseCode().isSuccess() && result.getReply().getValue() instanceof List) {
            Slice slice = this.getModel().getSlice(sliceUrn);
            assert (slice != null);
            List reply = (List)result.getReply().getValue();
            ArrayList<GeniUrn> usersUrns = new ArrayList<GeniUrn>();
            for (FederationSliceAuthorityApi2.UrnRoleTuple roleTuple : reply) {
                GeniUrn userUrn = roleTuple.getUrn();
                usersUrns.add(userUrn);
            }
            if (!usersUrns.isEmpty()) {
                slice.setUsers(usersUrns);
            }
        }
    }

    private void onGetProjectMembers(ApiCallDetails result) {
        GeniUrn projectUrn = (GeniUrn)result.getMethodParameters().get("urn");
        assert (projectUrn != null);
        this.noteUserCredentialInParameters(result);
        assert (result.getReply() != null);
        if (result.getReply() != null && result.getReply().getGeniResponseCode().isSuccess() && result.getReply().getValue() instanceof List) {
            List reply = (List)result.getReply().getValue();
            ArrayList<GeniUrn> usersUrns = new ArrayList<GeniUrn>();
            for (FederationSliceAuthorityApi2.UrnRoleTuple roleTuple : reply) {
                GeniUrn userUrn = roleTuple.getUrn();
                usersUrns.add(userUrn);
            }
            this.getModel().setUsersOfSubAuthority(projectUrn.getEncodedResourceName(), usersUrns);
        }
    }

    public void onResult(ApiCallDetails details) {
        assert (Platform.isFxApplicationThread());
        this.onResultInJavaFXThread(details);
    }

    public void onResultInJavaFXThread(ApiCallDetails result) {
        if (result.getReply() == null || result.getJavaMethodName() == null) {
            return;
        }
        if (!Objects.equals(result.getApiName(), FederationSliceAuthorityApi1.getApiName()) && !Objects.equals(result.getApiName(), FederationSliceAuthorityApi2.getApiName())) {
            return;
        }
        try {
            LOG.debug("onResult() methodName=" + result.getJavaMethodName() + " parameters.size(): " + result.getMethodParameters().size());
            if (Objects.equals(result.getApiName(), FederationSliceAuthorityApi1.getApiName())) {
                if (Objects.equals(result.getJavaMethodName(), "getSliceCredentials")) {
                    this.onGetSliceCredentials(result);
                }
                if (Objects.equals(result.getJavaMethodName(), "createSlice")) {
                    this.onCreateSlice(result);
                }
                if (Objects.equals(result.getJavaMethodName(), "lookupSlicesForMember")) {
                    this.onGetSlicesForMember1(result);
                }
                if (Objects.equals(result.getJavaMethodName(), "lookupProjectsForMember")) {
                    this.onGetProjectsForMember1(result);
                }
            }
            if (Objects.equals(result.getApiName(), FederationSliceAuthorityApi2.getApiName()) && result.getMethodParameters().containsKey("type")) {
                LOG.debug("onResult() v2 type=" + String.valueOf(result.getMethodParameters().get("type")) + "  methodName=" + result.getGeniMethodName() + " javaMethodname=" + result.getJavaMethodName());
                boolean matched = false;
                if (Objects.equals(result.getGeniMethodName(), "get_credentials") && Objects.equals(result.getMethodParameters().get("type"), "SLICE")) {
                    this.onGetSliceCredentials(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "lookup_members") && Objects.equals(result.getMethodParameters().get("type"), "SLICE")) {
                    this.onGetSliceMembers(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "lookup_members") && Objects.equals(result.getMethodParameters().get("type"), "PROJECT")) {
                    this.onGetProjectMembers(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "create") && Objects.equals(result.getMethodParameters().get("type"), "SLICE")) {
                    this.onCreateSlice(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "create") && Objects.equals(result.getMethodParameters().get("type"), "SLIVER_INFO")) {
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "lookup") && Objects.equals(result.getMethodParameters().get("type"), "SLIVER_INFO")) {
                    this.onLookupSliverInfoResult(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "lookup") && Objects.equals(result.getMethodParameters().get("type"), "PROJECT")) {
                    this.onLookupProjectResult(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "lookup") && Objects.equals(result.getMethodParameters().get("type"), "SLICE")) {
                    this.onLookupSliceInfoResult(result);
                    matched = true;
                }
                if (Objects.equals(result.getJavaMethodName(), "lookupForMember") && Objects.equals(result.getMethodParameters().get("type"), "SLICE")) {
                    this.onGetSlicesForMember2(result);
                    matched = true;
                }
                if (Objects.equals(result.getJavaMethodName(), "lookupForMember") && Objects.equals(result.getMethodParameters().get("type"), "PROJECT")) {
                    this.onGetProjectsForMember2(result);
                    matched = true;
                }
                if (Objects.equals(result.getGeniMethodName(), "delete") && Objects.equals(result.getMethodParameters().get("type"), "SLIVER_INFO")) {
                    this.onDeleteSliverInfo(result);
                    matched = true;
                }
                if (Objects.equals(result.getMethodParameters().get("type"), "SLICE_RSPEC")) {
                    LOG.debug("UNMATCHED onResult() for SLICE_RSPEC v2 type=" + String.valueOf(result.getMethodParameters().get("type")) + "  methodName=" + result.getGeniMethodName() + " javaMethodname=" + result.getJavaMethodName());
                    matched = true;
                }
                if (!matched) {
                    LOG.warn("UNMATCHED onResult() v2 type=" + String.valueOf(result.getMethodParameters().get("type")) + "  methodName=" + result.getGeniMethodName() + " javaMethodname=" + result.getJavaMethodName());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Exception when processing SliceAuthority reply for SfaModel. This will be ignored, but it is most likely a bug. ", (Throwable)e);
        }
    }

    private void onDeleteSliverInfo(ApiCallDetails result) {
        if (result == null || result.getReply() == null) {
            return;
        }
        if (result.getReply().getGeniResponseCode().isSuccess()) {
            assert (result.getMethodParameters().containsKey("credentialList"));
            List sliceCredentials = (List)result.getMethodParameters().get("credentialList");
            String sliceUrn = null;
            if (sliceCredentials != null && !sliceCredentials.isEmpty() && sliceCredentials.get(0) instanceof SfaCredential) {
                sliceUrn = ((SfaCredential)sliceCredentials.get(0)).getTargetUrn();
            }
            if (sliceUrn == null) {
                LOG.error("Could not derive sliceUrn from credential");
                return;
            }
            String sliverUrn = (String)result.getMethodParameters().get("urnToDelete");
            assert (sliverUrn != null);
            try {
                this.getModel().logNotExistSliver(sliceUrn, sliverUrn, Sliver.Source.SLICE_AUTHORITY);
            }
            catch (GeniUrn.GeniUrnParseException ex) {
                LOG.error("Could not unregister sliver with invalid sliver-urn {}", (Object)sliverUrn, (Object)ex);
            }
        }
    }
}

