/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateSliverTask;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllocateSliverTask
extends CreateTask {
    private static final Logger LOG = LoggerFactory.getLogger(AllocateSliverTask.class);
    @Nonnull
    private final Slice slice;
    @Nullable
    private final Instant startTime;
    @Nonnull
    private final Instant endTime;
    @Nonnull
    private final List<UserSpec> userSpecs;
    @Nullable
    private final RequestRspecSource overridingRequestRspecSource;
    @Nonnull
    private final Server server;
    @Nullable
    private String manifestRspec;
    @Nullable
    private Set<Sliver> allocatedSlivers = null;
    @Nullable
    private AbstractGeniAggregateManager.AggregateManagerReply rawReply;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final SliceRegistryUtil sliceRegistryUtil;
    @Nonnull
    private final SfaModel sfaModel;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public AllocateSliverTask(@Nonnull Slice slice, @Nullable Instant startTime, @Nonnull Instant endTime, @Nonnull List<UserSpec> userSpecs, @Nonnull Server server, @Nullable RequestRspecSource overridingRequestRspecSource, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull SliceRegistryUtil sliceRegistryUtil, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Allocate Sliver @ " + server.getDefaultComponentManagerUrn());
        this.slice = slice;
        this.startTime = startTime;
        this.endTime = endTime;
        this.userSpecs = userSpecs;
        this.server = server;
        this.overridingRequestRspecSource = overridingRequestRspecSource;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.sliceRegistryUtil = sliceRegistryUtil;
        this.sfaModel = sfaModel;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        HashSet allocateReplySlivers;
        List<Sliver> existingSlivers;
        block23: {
            RequestRspecSource requestRspecSource;
            existingSlivers = this.slice.findSlivers(this.server);
            ModelRspec.RequestRspecSpecialCases rspecSpecialCase = ModelRspec.RequestRspecSpecialCases.NONE;
            if (this.server.isServerType("planetlab") || this.server.getDefaultComponentManagerUrn().startsWith("urn:publicid:IDN+ple:ibbtple+authority+")) {
                rspecSpecialCase = ModelRspec.RequestRspecSpecialCases.PLE;
            }
            AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.server);
            assert (amWrapper.hasSeperateAllocateAndProvision());
            RequestRspecSource requestRspecSource2 = requestRspecSource = this.overridingRequestRspecSource != null ? this.overridingRequestRspecSource : this.slice.getRequestRspec();
            if (requestRspecSource == null) {
                throw new RuntimeException("No Request Rspec found. Cannot continue.");
            }
            LOG.trace("HLC.CreateSliverTask request RSpec before modification: expires={}", requestRspecSource.getImmutableModelRspec() != null ? requestRspecSource.getImmutableModelRspec().getExpiresString() : null);
            requestRspecSource = this.updateExpires(this.server, requestRspecSource, this.endTime);
            LOG.debug("HLC.CreateSliverTask request RSpec after modification: expires={}", requestRspecSource.getImmutableModelRspec() != null ? requestRspecSource.getImmutableModelRspec().getExpiresString() : null);
            String rspec = requestRspecSource.getRspecXmlString(rspecSpecialCase);
            if (rspec == null) {
                throw new RuntimeException("No Request Rspec found. Cannot continue.");
            }
            allocateReplySlivers = new HashSet();
            LOG.info("createSlivers @ {}  with user SSH keys: {}", (Object)this.server.getDefaultComponentManagerUrn(), this.sfaModel.getUserKeys());
            try {
                if (this.startTime == null) {
                    Instant usedExpirationDate = amWrapper.isExirationdateSetByCreateSliver() || this.server.hasFlag(Server.Flag.workaroundForceRenewAfterCreateSliver) ? this.endTime : null;
                    AggregateManagerWrapper.AllocateReply allocateReply = amWrapper.allocate(this.slice.getUrn(), this.slice.getCredentials(), rspec, usedExpirationDate != null ? Date.from(usedExpirationDate) : null);
                    this.rawReply = amWrapper.getLastReply();
                    if (allocateReply != null) {
                        this.manifestRspec = allocateReply.getManifest();
                    }
                    break block23;
                }
                if (this.server.hasFlag(Server.Flag.featureReservationsGeni)) {
                    AggregateManagerWrapper.AllocateReply allocateReply = amWrapper.allocate(this.slice.getUrn(), this.slice.getCredentials(), rspec, Date.from(this.startTime), Date.from(this.endTime));
                    this.rawReply = amWrapper.getLastReply();
                    if (allocateReply != null) {
                        this.manifestRspec = allocateReply.getManifest();
                        if (allocateReply.getSliverUrns() != null) {
                            allocateReplySlivers.addAll(allocateReply.getSliverUrns());
                        }
                    }
                    break block23;
                }
                if (this.server.hasFlag(Server.Flag.featureReservationsNitos)) {
                    ModelRspec requestWithLease = CreateSliverTask.createRequestWithNitosLease(rspec, this.server, this.startTime, this.endTime);
                    this.updateExpires(this.server, requestWithLease, this.endTime);
                    String requestWithLeaseRspecString = requestWithLease.toGeni3Rspec();
                    if (requestWithLeaseRspecString == null) {
                        throw new RuntimeException("Internal error: requestWithLeaseSource has empty rspec");
                    }
                    AggregateManagerWrapper.AllocateReply allocateReply = amWrapper.allocate(this.slice.getUrn(), this.slice.getCredentials(), requestWithLeaseRspecString, Date.from(this.startTime), Date.from(this.endTime));
                    this.rawReply = amWrapper.getLastReply();
                    if (allocateReply != null) {
                        this.manifestRspec = allocateReply.getManifest();
                    }
                    ArrayList<GeniUrn> failedResources = new ArrayList<GeniUrn>();
                    if (this.manifestRspec != null) {
                        failedResources.addAll(CreateSliverTask.checkForFailedNitosReservations(this.manifestRspec, this.server, requestWithLease));
                        if (!failedResources.isEmpty()) {
                            this.manifestRspec = null;
                            throw new JFedHighLevelException("Could not make a reservation for node(s) " + failedResources.stream().map(GeniUrn::toString).collect(Collectors.joining(", ")));
                        }
                        break block23;
                    }
                    throw new JFedHighLevelException("Reservation call was unsuccessful");
                }
                throw new JFedHighLevelException("Allocating a reservation is not supported on this authority!");
            }
            catch (AggregateManagerWrapper.NotEnoughFreeResourcesException e) {
                this.failedDueToNotEnoughFreeResources = true;
                this.manifestRspec = null;
                throw e;
            }
            catch (AggregateManagerWrapper.TermsAndConditionsException e) {
                this.failedDueToTermAndConditionsNotAccepted = true;
                this.manifestRspec = null;
                throw e;
            }
            catch (AggregateManagerWrapper.ReservationProblemException e) {
                this.failedDueToReservationProblem = true;
                this.manifestRspec = null;
                throw e;
            }
        }
        if (this.manifestRspec == null) {
            throw new JFedHighLevelException("Allocate of the sliver failed.");
        }
        this.allocatedSlivers = new HashSet<Sliver>();
        for (GeniUrn sliverUrn : allocateReplySlivers) {
            this.allocatedSlivers.add(this.sfaModel.logExistSliver(this.slice.getUrn(), sliverUrn, Sliver.Source.AGGREGATE_MANAGER_STATUS));
        }
        List<Sliver> manifestSlivers = SfaModelAbstractListener.findSliversInManifest(this.sfaModel, this.server, this.slice.getUrn(), new ManifestRspecSource(this.manifestRspec, ModelRspecType.FX));
        if (manifestSlivers != null) {
            this.allocatedSlivers.addAll(manifestSlivers);
        }
        this.allocatedSlivers.addAll(this.slice.getSliversStream().filter(arg_0 -> ((Server)this.server).equals(arg_0)).collect(Collectors.toSet()));
        this.allocatedSlivers.removeAll(existingSlivers);
        if (!this.allocatedSlivers.isEmpty()) {
            this.sliceRegistryUtil.registerSliversAtSATaskExecution(this.allocatedSlivers, this.endTime, this, new ResultListener[0]);
        } else {
            LOG.info("Could not find any slivers that were newly created during Allocate call! This means that all new slivers MUST be created in Provision-call. Pre-existing slivers: " + (existingSlivers.isEmpty() ? "none" : existingSlivers.stream().map(Sliver::getUrnString).collect(Collectors.joining(", "))));
        }
    }

    @Nonnull
    public Set<Sliver> getCreatedSlivers() {
        return this.allocatedSlivers != null ? Collections.unmodifiableSet(this.allocatedSlivers) : Collections.emptySet();
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Nonnull
    public Slice getSlice() {
        return this.slice;
    }

    @Override
    @Nonnull
    public Server getServer() {
        return this.server;
    }

    @Nullable
    public String getManifestRspec() {
        return this.manifestRspec;
    }

    @Nullable
    public AbstractGeniAggregateManager.AggregateManagerReply getRawReply() {
        return this.rawReply;
    }
}

