/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.SfaModelAbstractListener;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateSliverTask
extends CreateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSliverTask.class);
    private final Slice slice;
    @Nullable
    private final Instant startTime;
    private final Instant endTime;
    private final List<UserSpec> userSpecs;
    @Nullable
    private final RequestRspecSource overridingRequestRspecSource;
    private final Server server;
    private String manifestRspec;
    private Set<Sliver> createdSlivers = null;
    private final List<Task> extraDependencies = new ArrayList<Task>();
    private static final FXRspecFactory rspecFactory = FXRspecFactory.getInstance();
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final SliceRegistryUtil sliceRegistryUtil;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory highLevelTaskFactory;
    private AbstractGeniAggregateManager.AggregateManagerReply rawReply;

    public CreateSliverTask(@Nonnull Slice slice, @Nullable Instant startTime, @Nonnull Instant endTime, @Nonnull Server server, @Nonnull List<UserSpec> userSpecs, @Nullable RequestRspecSource overridingRequestRspecSource, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull SliceRegistryUtil sliceRegistryUtil, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Create Sliver @ " + server.getDefaultComponentManagerUrn());
        this.slice = slice;
        this.startTime = startTime;
        this.endTime = endTime;
        this.server = server;
        this.userSpecs = userSpecs;
        this.overridingRequestRspecSource = overridingRequestRspecSource;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.sliceRegistryUtil = sliceRegistryUtil;
        this.sfaModel = sfaModel;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        List<Sliver> existingSlivers;
        block20: {
            RequestRspecSource requestRspecSource;
            existingSlivers = this.slice.findSlivers(this.server);
            ModelRspec.RequestRspecSpecialCases rspecSpecialCase = ModelRspec.RequestRspecSpecialCases.NONE;
            if (this.server.isServerType("planetlab") || this.server.getDefaultComponentManagerUrn().startsWith("urn:publicid:IDN+ple:ibbtple+authority+")) {
                rspecSpecialCase = ModelRspec.RequestRspecSpecialCases.PLE;
            }
            AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.server);
            assert (this.server.hasFlag(Server.Flag.featureReservationsNitos) || !amWrapper.hasSeperateAllocateAndProvision()) : "AM Wrapper supports provisioning, so we shouldn't be doing CreateSliver!";
            RequestRspecSource requestRspecSource2 = requestRspecSource = this.overridingRequestRspecSource != null ? this.overridingRequestRspecSource : this.slice.getRequestRspec();
            if (requestRspecSource == null) {
                throw new JFedHighLevelException("Could not find request RSpec");
            }
            String rspecString = (requestRspecSource = this.updateExpires(this.server, requestRspecSource, this.endTime)).getRspecXmlString(rspecSpecialCase);
            if (rspecString == null) {
                throw new JFedHighLevelException("Could not convert request RSpec to String");
            }
            LOG.info("createSlivers @ {}  with user SSH keys: {}", (Object)this.server.getDefaultComponentManagerUrn(), this.sfaModel.getUserKeys());
            try {
                if (this.startTime == null) {
                    Instant usedExpirationDate = amWrapper.isExirationdateSetByCreateSliver() || this.server.hasFlag(Server.Flag.workaroundForceRenewAfterCreateSliver) ? this.endTime : null;
                    this.manifestRspec = amWrapper.createSliver(this.slice.getUrn(), this.slice.getCredentials(), rspecString, this.userSpecs, usedExpirationDate != null ? Date.from(usedExpirationDate) : null);
                    this.rawReply = amWrapper.getLastReply();
                    break block20;
                }
                if (this.server.hasFlag(Server.Flag.featureReservationsNitos)) {
                    ModelRspec requestWithLease = CreateSliverTask.createRequestWithNitosLease(rspecString, this.server, this.startTime, this.endTime);
                    this.updateExpires(this.server, requestWithLease, this.endTime);
                    String nitosRspecString = requestWithLease.toGeni3Rspec();
                    if (nitosRspecString == null) {
                        throw new JFedHighLevelException("Could not convert Nitos Request RSpec to String, so cannot Create Slivers. This is probably due to a bug in jFed.");
                    }
                    this.manifestRspec = amWrapper.createSliver(this.slice.getUrn(), this.slice.getCredentials(), nitosRspecString, this.userSpecs, Date.from(this.endTime));
                    this.rawReply = amWrapper.getLastReply();
                    ArrayList<GeniUrn> failedResources = new ArrayList<GeniUrn>();
                    if (this.manifestRspec != null) {
                        failedResources.addAll(CreateSliverTask.checkForFailedNitosReservations(this.manifestRspec, this.server, requestWithLease));
                        if (!failedResources.isEmpty()) {
                            this.manifestRspec = null;
                            throw new JFedHighLevelException("Could not make a reservation for node(s) " + failedResources.stream().map(GeniUrn::toString).collect(Collectors.joining(", ")));
                        }
                        break block20;
                    }
                    throw new JFedHighLevelException("Reservation call was unsuccessful");
                }
                throw new JFedHighLevelException("Making a reservation is not supported on this authority!");
            }
            catch (AggregateManagerWrapper.NotEnoughFreeResourcesException e) {
                this.failedDueToNotEnoughFreeResources = true;
                this.manifestRspec = null;
                throw new JFedHighLevelException("Creation of the sliver failed: could not map to resources (resource shortage or unsupported topology)", e);
            }
            catch (AggregateManagerWrapper.TermsAndConditionsException e) {
                this.failedDueToTermAndConditionsNotAccepted = true;
                this.manifestRspec = null;
                throw new JFedHighLevelException("Creation of the sliver failed: Testbed access refused due to Terms & Conditions not accepted", e);
            }
            catch (AggregateManagerWrapper.ReservationProblemException e) {
                this.failedDueToReservationProblem = true;
                this.manifestRspec = null;
                throw new JFedHighLevelException("Creation of the sliver failed: Problem related to reservation of resources.", e);
            }
        }
        if (this.manifestRspec == null) {
            throw new JFedHighLevelException("Creation of the sliver failed.");
        }
        this.createdSlivers = new HashSet<Sliver>();
        List<Sliver> manifestSlivers = SfaModelAbstractListener.findSliversInManifest(this.sfaModel, this.server, this.slice.getUrn(), new ManifestRspecSource(this.manifestRspec, ModelRspecType.FX));
        if (manifestSlivers != null) {
            this.createdSlivers.addAll(manifestSlivers);
        }
        this.createdSlivers.addAll(this.slice.getSliversStream().filter(arg_0 -> ((Server)this.server).equals(arg_0)).collect(Collectors.toSet()));
        this.createdSlivers.removeAll(existingSlivers);
        if (!this.createdSlivers.isEmpty()) {
            this.sliceRegistryUtil.registerSliversAtSATaskExecution(this.createdSlivers, this.endTime, this, new ResultListener[0]);
        }
        if (this.createdSlivers.isEmpty()) {
            boolean isStitching;
            try {
                StringRspec sr = new StringRspec(this.manifestRspec);
                isStitching = sr.isStitching(this.highLevelTaskFactory.getTestbedInfoSource(), this.highLevelTaskFactory.getAuthorityFinder()) != Boolean.FALSE;
            }
            catch (Exception e) {
                LOG.error("Could not use StringRspec to determine if the manifest is a stitching manifest. Will use fallback.", (Throwable)e);
                isStitching = this.manifestRspec.contains("switchingCapabilityDescriptor");
            }
            if (!isStitching) {
                throw new JFedHighLevelException("Could not find any slivers that were newly created! Pre-existing slivers: " + existingSlivers.stream().map(Sliver::getUrnString).collect(Collectors.joining(", ")));
            }
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        res.addAll(this.extraDependencies);
        return res;
    }

    public void addExtraDependency(Task t) {
        this.extraDependencies.add(t);
    }

    public Slice getSlice() {
        return this.slice;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    public Set<Sliver> getCreatedSlivers() {
        return Collections.unmodifiableSet(this.createdSlivers);
    }

    public AbstractGeniAggregateManager.AggregateManagerReply getRawReply() {
        return this.rawReply;
    }

    public static ModelRspec createRequestWithNitosLease(@Nonnull String requestRspec, @Nonnull Server auth, @Nonnull Instant reservationStartTime, @Nonnull Instant reservationEndTime) throws JFedHighLevelException {
        ImmutableRequestRspecSource requestCopy = new ImmutableRequestRspecSource(requestRspec, ModelRspecType.FX);
        if (requestCopy.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]) == null) {
            throw new JFedHighLevelException("Could not parse request rspec into model: got null!");
        }
        if (requestCopy.isLosingData(ModelRspecType.FX)) {
            throw new JFedHighLevelException("Lost data while parsing request rspec: " + String.valueOf(requestCopy.getLosingDataDifferences(ModelRspecType.FX)));
        }
        ModelRspec requestWithLease = requestCopy.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        if (requestWithLease == null) {
            throw new RuntimeException("Internal error converting request RSpec to string and back again.");
        }
        String clientLeaseId = UUID.randomUUID().toString();
        Lease newLease = rspecFactory.createLease(requestWithLease, null, clientLeaseId, Date.from(reservationStartTime), Date.from(reservationEndTime));
        requestWithLease.addLease(newLease);
        requestWithLease.getNodes().stream().filter(node -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), node.getComponentManagerId())).forEach(node -> {
            node.getLeaseIdRefs().clear();
            node.addLeaseIdRef(clientLeaseId);
        });
        requestWithLease.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).forEach(channel -> {
            channel.getLeaseIdRefs().clear();
            channel.addLeaseIdRef(clientLeaseId);
        });
        return requestWithLease;
    }

    public static List<GeniUrn> checkForFailedNitosReservations(@Nonnull String manifestRspec, @Nonnull Server auth, @Nonnull ModelRspec requestWithLease) {
        ArrayList<GeniUrn> failedResources = new ArrayList<GeniUrn>();
        int prevCount = 0;
        ManifestRspecSource manifestRspecSource = new ManifestRspecSource(new StringRspec(manifestRspec));
        FXModelRspec modelRspec = (FXModelRspec)manifestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (modelRspec != null);
        if (modelRspec == null) {
            throw new RuntimeException("Internal error converting manifestRspec to string and back again.");
        }
        failedResources.addAll(modelRspec.getNodes().stream().filter(rspecNode -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), rspecNode.getComponentManagerId())).filter(rspecNode -> rspecNode.getLeaseIdRefs().isEmpty()).map(RspecNode::getComponentId).collect(Collectors.toList()));
        if (prevCount != failedResources.size()) {
            LOG.debug("checkForFailedNitosReservations found failed reservation: empty node leaseIdRef. " + String.valueOf(failedResources));
        }
        prevCount = failedResources.size();
        failedResources.addAll(modelRspec.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).filter(channel -> channel.getLeaseIdRefs().isEmpty()).map(Channel::getComponentId).collect(Collectors.toList()));
        if (prevCount != failedResources.size()) {
            LOG.debug("checkForFailedNitosReservations found failed reservation: empty channel leaseIdRef. " + String.valueOf(failedResources));
        }
        prevCount = failedResources.size();
        failedResources.addAll(requestWithLease.getNodes().stream().filter(node -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), node.getComponentManagerId())).filter(node -> modelRspec.getNodeByClientId(node.getClientId()) == null && (node.getComponentId() == null || modelRspec.getNodeByComponentId(node.getComponentId().getValue()) == null)).map(RspecNode::getComponentId).collect(Collectors.toList()));
        if (prevCount != failedResources.size()) {
            LOG.debug("checkForFailedNitosReservations found failed reservation: request node absent in manifest. " + String.valueOf(failedResources));
        }
        prevCount = failedResources.size();
        failedResources.addAll(requestWithLease.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).filter(channel -> modelRspec.getChannelByComponentId(channel.getComponentId()) == null && (channel.getComponentId() == null || modelRspec.getNodeByComponentId(channel.getComponentId().getValue()) == null)).map(Channel::getComponentId).collect(Collectors.toList()));
        if (prevCount != failedResources.size()) {
            LOG.debug("checkForFailedNitosReservations found failed reservation: request channel absent in manifest. " + String.valueOf(failedResources));
        }
        prevCount = failedResources.size();
        return failedResources;
    }
}

