/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class CreateTask
extends Task {
    protected boolean failedDueToNotEnoughFreeResources = false;
    protected boolean failedDueToReservationProblem = false;
    protected boolean failedDueToTermAndConditionsNotAccepted = false;

    public CreateTask(String name) {
        super(name);
    }

    public abstract Server getServer();

    public final boolean hasFailedDueToNotEnoughFreeResources() {
        return this.failedDueToNotEnoughFreeResources;
    }

    public boolean hasFailedDueToReservationProblem() {
        return this.failedDueToReservationProblem;
    }

    public boolean hasFailedDueToTermAndConditionsNotAccepted() {
        return this.failedDueToTermAndConditionsNotAccepted;
    }

    protected void updateExpires(@Nonnull Server server, @Nonnull ModelRspec origModel, @Nullable Instant requestedEndTime) {
        if (requestedEndTime != null && server.hasFlag(Server.Flag.workaroundAddExpiresAttributeToRequestRspec)) {
            origModel.setExpires(Date.from(requestedEndTime));
        } else {
            origModel.setExpires((String)null);
        }
    }

    protected RequestRspecSource updateExpires(@Nonnull Server server, @Nonnull RequestRspecSource origSource, @Nullable Instant requestedEndTime) {
        ModelRspec modelRspec = origSource.getMutableModelRspec();
        if (modelRspec == null) {
            throw new NullPointerException("Unexpected null modelRSpec");
        }
        modelRspec = modelRspec.copy();
        this.updateExpires(server, modelRspec, requestedEndTime);
        return new ImmutableRequestRspecSource(modelRspec);
    }

    public abstract Collection<Sliver> getCreatedSlivers();
}

