/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class DeleteImageTask
extends Task {
    private final Server auth;
    private final GeniUrn imageUrn;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public DeleteImageTask(Server auth, GeniUrn imageUrn, UserAndSliceApiWrapper userAndSliceApiWrapper, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        super("Delete Image " + String.valueOf(imageUrn) + " on " + auth.getDefaultComponentManagerUrn());
        this.auth = auth;
        this.imageUrn = imageUrn;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        if (!amWrapper.areUserDiskImageFunctionsSupported()) {
            throw new JFedHighLevelException("Authority " + this.auth.getDefaultComponentManagerUrn() + " does not support list image.");
        }
        if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
            throw new JFedHighLevelException("UserAndSliceApiWrapper did not have user Credentials.");
        }
        amWrapper.deleteImage(this.userAndSliceApiWrapper.getCachedUserCredentialsForAM(), this.imageUrn);
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }
}

