/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.SliceRegistryUtil;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteSliversAtAuthorityTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(DeleteSliversAtAuthorityTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Server auth;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final SliceRegistryUtil sliceRegistryUtil;

    public DeleteSliversAtAuthorityTask(@Nonnull Slice slice, @Nonnull Server authority, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull SliceRegistryUtil sliceRegistryUtil) {
        super("Delete All Slivers on slice " + String.valueOf(slice.getUrn()) + "@" + authority.getName());
        this.slice = slice;
        this.auth = authority;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.sliceRegistryUtil = sliceRegistryUtil;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        if (this.auth.isEdgeVlan()) {
            throw new JFedHighLevelException("Cannot delete resources at fake resource!");
        }
        if (!ApiInfo.hasService((Server)this.auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM)) {
            LOG.error("Slice has component manager '{}', but that authority has no known AM URL: cannot delete there.", (Object)this.auth.getDefaultComponentManagerUrn());
            throw new JFedHighLevelException("Slice.getDefaultComponentManagerUrn() manager \"" + this.auth.getDefaultComponentManagerUrn() + "\", but that authority has no known AM URL: cannot delete there.");
        }
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        amWrapper.deleteSliver(this.slice.getUrn(), this.slice.getCredentials());
        this.sliceRegistryUtil.unregisterSliversAtSATaskExecution(this.slice, this.auth, new ResultListener[0]);
    }

    @Nonnull
    public Server getAuthority() {
        return this.auth;
    }
}

