/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ListSubAuthoritiesTask
extends Task {
    private UserAndSliceApiWrapper.SubAuthoritySupport subAuthoritySupport;
    private List<String> subAuthNames;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public ListSubAuthoritiesTask(UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, GeniUserProvider geniUserProvider, SfaModel sfaModel, HighLevelTaskFactory highLevelTaskFactory) {
        super("List Sub Authorities");
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.sfaModel = sfaModel;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.subAuthoritySupport = this.userAndSliceApiWrapper.getSubAuthoritySupport((Logger)JavaFXLogger.wrap(this.logger, taskExecution));
        this.sfaModel.setSubAuthoritySupport(this.subAuthoritySupport);
        this.subAuthNames = this.userAndSliceApiWrapper.getSubAuthorityNames((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
    }

    public List<String> getSubAuthNames() {
        return this.subAuthNames;
    }

    public UserAndSliceApiWrapper.SubAuthoritySupport getSubAuthoritySupport() {
        return this.subAuthoritySupport;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }
}

