/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OtherUserSshKeysTask
extends Task {
    @Nonnull
    private final GeniUrn userUrn;
    @Nonnull
    private final List<Task> extraTaskDeps;
    @Nullable
    private List<String> keys;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public OtherUserSshKeysTask(@Nonnull GeniUrn userUrn, @Nonnull List<Task> extraTaskDeps, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("Get SSH keys for " + String.valueOf(userUrn));
        this.userUrn = userUrn;
        this.extraTaskDeps = extraTaskDeps;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.keys = this.userAndSliceApiWrapper.getSshKeysForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.userUrn);
    }

    @Nonnull
    public GeniUrn getUserUrn() {
        return this.userUrn;
    }

    @Nonnull
    public List<String> getKeys() {
        return this.keys == null ? Collections.emptyList() : this.keys;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getUserCredential());
        res.addAll(this.extraTaskDeps);
        return res;
    }
}

