/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class PoaTask
extends Task {
    @Nonnull
    protected final Slice slice;
    @Nonnull
    protected final Server auth;
    @Nonnull
    protected final GeniUrn poaTarget;
    @Nonnull
    protected final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    protected final HighLevelTaskFactory highLevelTaskFactory;

    public PoaTask(@Nonnull String name, @Nonnull Slice slice, @Nonnull Server auth, @Nonnull GeniUrn poaTarget, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super(name);
        this.slice = slice;
        this.auth = auth;
        this.poaTarget = poaTarget;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        this.doPoaAction(amWrapper);
    }

    public abstract void doPoaAction(@Nonnull AggregateManagerWrapper var1) throws JFedException;

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }
}

