/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.ReputationTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.ReputationService;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;

public class RegisterReputationTask
extends ReputationTask {
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final List<GeniUrn> resources;
    private final int overallScore;
    private final int qualityScore;
    private final int availabilityScore;

    public RegisterReputationTask(@Nonnull Slice slice, @Nonnull List<GeniUrn> resources, int overallScore, int qualityScore, int availabilityScore, @Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super("Registering reputation questionnaire to Reputation Service", logger, jFedPreferences, testbedInfoSource, connectionProvider, geniUserProvider);
        this.slice = slice;
        this.resources = resources;
        this.overallScore = overallScore;
        this.qualityScore = qualityScore;
        this.availabilityScore = availabilityScore;
    }

    @Override
    protected void doReputationTask(TaskExecution taskExecution, ReputationService reputationService) throws JFedException {
        if (this.slice.getCreationDate() == null || this.slice.getExpirationDate() == null) {
            throw new RuntimeException("Cannot register Reputation questionaire: some slice info is missing. (this is an internal jFed error)urn=" + String.valueOf(this.slice.getUrn()) + (this.slice.getCreationDate() == null ? " cd" : "") + (this.slice.getExpirationDate() == null ? " ed" : ""));
        }
        reputationService.registerUserQOE(this.createConnection(), this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), this.slice.getUrn(), Date.from(this.slice.getCreationDate()), Date.from(this.slice.getExpirationDate()), this.resources, this.overallScore, this.qualityScore, this.availabilityScore);
    }
}

