/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterOrUpdateSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SlaTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterSliversToSLACollectorTask
extends SlaTask {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterOrUpdateSliversTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Collection<GeniUrn> createdSliverUrns;
    @Nonnull
    private final Server auth;

    public RegisterSliversToSLACollectorTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> createdSliverUrns, @Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super("Registering slivers created @ " + auth.getName() + " to SLA Collector", logger, jFedPreferences, testbedInfoSource, connectionProvider, geniUserProvider);
        this.slice = slice;
        this.createdSliverUrns = createdSliverUrns;
        this.auth = auth;
    }

    @Override
    protected void doSlaTask(@Nonnull TaskExecution taskExecution, @Nonnull SlaCollector slaCollector) throws JFedException {
        String slaUuid = this.slice.getUuid();
        if (slaUuid == null) {
            throw new JFedHighLevelException("Slice has no UUID, and can thus not be registered with the SLA");
        }
        if (this.slice.getExpirationDate() == null) {
            throw new JFedHighLevelException("Slice has no expiration date, and can thus not be registered with the SLA");
        }
        RestApi.RestReply result = slaCollector.registerSLA(this.createConnection(), slaUuid, this.auth.getDefaultComponentManagerAsGeniUrn(), Date.from(this.slice.getExpirationDate()), this.slice.getUrn(), this.geniUserProvider.getLoggedInGeniUser().getUserUrn(), this.createdSliverUrns);
        if (result.getHttpCallDetails().getResultHttpStatusCode() != 200) {
            throw new JFedHighLevelException("Error while registering slivers to SLA collector");
        }
        result = slaCollector.registerStart(this.createConnection(), this.slice.getUuid(), this.auth.getDefaultComponentManagerAsGeniUrn());
        if (result.getHttpCallDetails().getResultHttpStatusCode() / 100 != 2) {
            throw new JFedHighLevelException("Error while registering start of slivers at " + this.auth.getName() + " to SLA collector");
        }
    }

    public Server getAuthority() {
        return this.auth;
    }
}

