/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.ReputationService;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;

public abstract class ReputationTask
extends Task {
    private static final String REPUTATION_SERVICE_ID = "reputationservice";
    private final JavaFXLogger logger;
    private final JFedPreferences jFedPreferences;
    private final TestbedInfoSource testbedInfoSource;
    private final JFedConnectionProvider connectionProvider;
    protected final GeniUserProvider geniUserProvider;

    public ReputationTask(String name, JavaFXLogger logger, JFedPreferences jFedPreferences, TestbedInfoSource testbedInfoSource, JFedConnectionProvider connectionProvider, GeniUserProvider geniUserProvider) {
        super(name);
        this.logger = logger;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.connectionProvider = connectionProvider;
        this.geniUserProvider = geniUserProvider;
    }

    protected HttpConnection createConnection() throws JFedException {
        Testbed reputationServiceTestbed = this.testbedInfoSource.getTestbedById(REPUTATION_SERVICE_ID);
        Server reputationServer = reputationServiceTestbed.getDefaultServer();
        if (reputationServer == null) {
            throw new JFedHighLevelException("No reputation server defined! Check your testbeds.xml");
        }
        GeniUser loggedInGeniUser = this.geniUserProvider.getLoggedInGeniUser();
        return (HttpConnection)this.connectionProvider.getConnectionByAuthority(loggedInGeniUser, reputationServer, new ApiInfo.Api(ApiInfo.ApiName.FED4FIRE_REPUTATION_SERVICE, 1));
    }

    @Override
    protected final void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        ReputationService reputationService = new ReputationService((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.jFedPreferences);
        this.doReputationTask(taskExecution, reputationService);
    }

    protected abstract void doReputationTask(TaskExecution var1, ReputationService var2) throws JFedException;
}

