/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;

public abstract class SlaTask
extends Task {
    private static final String SLA_COLLECTOR_ID = "slacollector";
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final JFedPreferences jFedPreferences;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final JFedConnectionProvider connectionProvider;
    @Nonnull
    protected final GeniUserProvider geniUserProvider;

    public SlaTask(@Nonnull String name, @Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super(name);
        this.logger = logger;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        this.connectionProvider = connectionProvider;
        this.geniUserProvider = geniUserProvider;
    }

    @Nonnull
    protected HttpConnection createConnection() throws JFedException {
        Testbed slaTestbed = this.testbedInfoSource.getTestbedById(SLA_COLLECTOR_ID);
        Server slaAuth = slaTestbed.getDefaultServer();
        if (slaAuth == null) {
            throw new JFedHighLevelException("No SLA Collector authority defined! Check your testbeds.xml");
        }
        GeniUser loggedInGeniUser = this.geniUserProvider.getLoggedInGeniUser();
        return (HttpConnection)this.connectionProvider.getConnectionByAuthority(loggedInGeniUser, slaAuth, new ApiInfo.Api(ApiInfo.ApiName.FED4FIRE_SLA_COLLECTOR, 1));
    }

    @Override
    protected final void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        SlaCollector slaCollector = new SlaCollector((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.jFedPreferences);
        this.doSlaTask(taskExecution, slaCollector);
    }

    protected abstract void doSlaTask(@Nonnull TaskExecution var1, @Nonnull SlaCollector var2) throws JFedException;
}

