/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class SliceCredentialTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SliceCredentialTask.class);
    private final Slice slice;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final HighLevelTaskFactory highLevelTaskFactory;

    SliceCredentialTask(@Nonnull Slice slice, UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, HighLevelTaskFactory highLevelTaskFactory) {
        super("Get Slice Credential " + String.valueOf(slice.getUrn()));
        this.slice = slice;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        try {
            this.userAndSliceApiWrapper.getSliceCredentials((Logger)JavaFXLogger.wrap(true, this.logger, taskExecution), GeniUrn.parse((String)this.slice.getUrnString()));
        }
        catch (JFedException ex) {
            if (ex.getXmlRpcReply() != null && ex.getXmlRpcReply().getGeniResponseCode() == GeniAMResponseCode.GENIRESPONSE_SEARCHFAILED) {
                this.slice.getSliversStream().filter(sliver -> sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.FAIL).forEach(sliver -> sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED)));
            }
            throw ex;
        }
        if (!this.slice.hasCredential()) {
            throw new JFedHighLevelException("Error processing reply: No valid slice credential was found");
        }
        if (this.slice.isExpired()) {
            this.slice.getSliversStream().filter(sliver -> sliver.getStatus().getGlobalStatus() != StatusDetails.SliverStatus.FAIL).forEach(sliver -> sliver.setStatus(new StatusDetails(StatusDetails.SliverStatus.UNALLOCATED)));
            throw new JFedHighLevelException("Error processing reply: got credential for expired slice");
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }

    @Override
    public boolean newExecutionNeeded() {
        if (this.slice.isExpired()) {
            LOG.warn("Slice " + this.slice.getUrnString() + " has expired, so a new execution of Get Slice Credential is needed.");
            return true;
        }
        return !this.slice.hasCredential();
    }
}

