/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.log.ResultListener;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.LoggerFactory;

public final class UnregisterSliversTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(UnregisterSliversTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Collection<GeniUrn> deletedSliverUrns;
    @Nullable
    private final Task extraTaskToDependOn;
    @Nonnull
    private final Server auth;
    @Nonnull
    private final ResultListener[] extraResultListeners;
    @Nonnull
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    @Nonnull
    private final JavaFXLogger logger;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;

    public UnregisterSliversTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull Collection<GeniUrn> deletedSliverUrns, @Nullable Task extraTaskToDependOn, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory, ResultListener ... extraResultListeners) {
        super("UnregisterSliversTask slivers deleted @ " + auth.getDefaultComponentManagerUrn());
        this.slice = slice;
        this.deletedSliverUrns = deletedSliverUrns;
        this.auth = auth;
        this.extraTaskToDependOn = extraTaskToDependOn;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.extraResultListeners = extraResultListeners;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        ResultListener[] resultListeners = Arrays.copyOf(this.extraResultListeners, this.extraResultListeners.length + 1);
        resultListeners[this.extraResultListeners.length] = taskExecution;
        JavaFXLogger logger = JavaFXLogger.wrap(this.logger, resultListeners);
        Collection<GeniUrn> sliverUrns = this.deletedSliverUrns;
        LOG.debug("UnregisterSliversTask has {} sliver Urns to unregister.", (Object)sliverUrns.size());
        if (!sliverUrns.isEmpty()) {
            this.userAndSliceApiWrapper.unregisterAggregatesForSlice((Logger)logger, this.slice.getCredentials(), this.slice.getUrn(), this.auth.getDefaultComponentManagerAsGeniUrn(), sliverUrns);
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        if (this.extraTaskToDependOn != null) {
            res.add(this.extraTaskToDependOn);
        }
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }
}

