/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.util.common.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalFileUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalFileUtil.class);
    @Nonnull
    private final SSHClient ssh;
    @Nullable
    private String homedir;

    public ExternalFileUtil(@Nonnull SSHClient ssh) {
        this.ssh = ssh;
    }

    @Nonnull
    public String getFolder(@Nonnull String fullPath) {
        int separatorLocation = fullPath.lastIndexOf(47);
        if (separatorLocation == -1) {
            LOG.warn("Path {} is an invalid file path", (Object)fullPath);
            throw new IllegalArgumentException("Path '" + fullPath + "' is not a valid file path");
        }
        String folder = fullPath.substring(0, separatorLocation);
        if (folder.contains("~")) {
            if (this.homedir == null) {
                this.retrieveHomedir();
            }
            assert (this.homedir != null);
            folder = folder.replace("~", this.homedir);
        }
        return folder;
    }

    @Nonnull
    public String getHomeDir() {
        if (this.homedir == null) {
            this.retrieveHomedir();
        }
        return this.homedir;
    }

    @Nonnull
    public String retrieveHomedir() {
        block16: {
            try (Session session = this.ssh.startSession();){
                Session.Command command = session.exec("pwd");
                command.join();
                if (command.getExitStatus() == 0) {
                    try (BufferedReader buffer = new BufferedReader(new InputStreamReader(command.getInputStream()));){
                        this.homedir = buffer.readLine();
                    }
                    LOG.info("Retrieved  homedir '{}' from {}", (Object)this.homedir, (Object)this.ssh.getRemoteHostname());
                    if (this.homedir == null) {
                        throw new RuntimeException("Could not retrieve the homefolder on the external system (got null)");
                    }
                    break block16;
                }
                LOG.error("Error while executing 'pwd' on {}", (Object)this.ssh.getRemoteHostname());
                throw new RuntimeException("Error while executing 'pwd' on " + this.ssh.getRemoteHostname());
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not retrieve the homefolder on the external system", ex);
            }
        }
        return this.homedir;
    }

    @Nonnull
    public static String getBasename(@Nonnull String fullPath) {
        return IOUtils.getUnixBasename((String)fullPath);
    }

    @Nonnull
    public static String getPathOnly(@Nonnull String fullPath) {
        return IOUtils.getUnixPathOnly((String)fullPath);
    }
}

