/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ProxyService;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProxyServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyServiceUtil.class);
    private final GeniUserProvider geniUserProvider;

    @Inject
    public ProxyServiceUtil(GeniUserProvider geniUserProvider) {
        this.geniUserProvider = geniUserProvider;
    }

    public JFedConnection.SshProxyInfo findTestbedProxy(@Nonnull RspecNode node, @Nonnull LoginService loginService) {
        assert (node.getLoginServices().contains(loginService));
        if (node.getProxyServices().isEmpty()) {
            LOG.debug("findTestbedProxy: node has no login proxy info");
            return null;
        }
        LOG.debug("findTestbedProxy: node has " + node.getProxyServices().size() + " login proxy info");
        String loginServiceString = ProxyServiceUtil.loginServiceToString(loginService);
        for (ProxyService proxyService : node.getProxyServices()) {
            LOG.debug("findTestbedProxy: checking if " + loginServiceString + " matches proxy for " + proxyService.getFor() + " (proxy=" + proxyService.getProxy() + ")");
            if (!Objects.equals(loginServiceString, proxyService.getFor())) continue;
            assert (proxyService.getProxy() != null);
            return this.stringToProxyInfo(proxyService.getProxy(), proxyService.getHostKey());
        }
        return null;
    }

    public static List<LoginService> nonProxyLoginServices(@Nonnull RspecNode manifestNode) {
        List loginServices = manifestNode.getLoginServices();
        LOG.debug("nonProxyLoginServices: There are " + loginServices.size() + " proxies.");
        if (manifestNode.getProxyServices().isEmpty()) {
            return loginServices;
        }
        for (ProxyService proxyService : manifestNode.getProxyServices()) {
            Iterator it = loginServices.iterator();
            while (it.hasNext()) {
                LoginService curLs = (LoginService)it.next();
                if (!Objects.equals(ProxyServiceUtil.loginServiceToString(curLs), proxyService.getProxy())) continue;
                LOG.debug("nonProxyLoginServices: Ignoring login service " + ProxyServiceUtil.loginServiceToString(curLs) + " because it is a proxy.");
                it.remove();
            }
        }
        return loginServices;
    }

    private static String loginServiceToString(@Nonnull LoginService loginService) {
        return loginService.getUsername() + "@" + loginService.getHostname() + ":" + loginService.getPort();
    }

    private JFedConnection.SshProxyInfo stringToProxyInfo(@Nonnull String proxyString, @Nullable String hostKey) {
        String hostname;
        String username;
        String originalProxyString = proxyString;
        int port = 22;
        int atPos = proxyString.indexOf("@");
        if (atPos >= 0) {
            username = proxyString.substring(0, atPos);
        } else {
            LOG.warn("No username could be found in proxy-string '{}'", (Object)originalProxyString);
            username = null;
        }
        proxyString = proxyString.substring(atPos + 1);
        int semiColonPos = proxyString.lastIndexOf(":");
        if (semiColonPos >= 0) {
            try {
                port = Integer.parseInt(proxyString.substring(semiColonPos + 1));
            }
            catch (NumberFormatException ex) {
                LOG.error("Could not properly parse port number in proxy-string '{}'", (Object)originalProxyString);
                port = 22;
            }
            hostname = proxyString.substring(0, semiColonPos);
        } else {
            LOG.warn("No port number could be found in proxy-string '{}'", (Object)originalProxyString);
            hostname = proxyString;
        }
        GeniUserSshKeyInfo sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)this.geniUserProvider.getLoggedInGeniUser());
        return new JFedConnection.SshProxyInfo(hostname, port, username, (SshKeyInfo)sshKeyInfo, hostKey);
    }
}

