/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.net.SocketFactory;

@Singleton
public class ProxySocketFactoryProviderImpl
implements ProxySocketFactoryProvider {
    private final GeniUserProvider geniUserProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;

    @Inject
    public ProxySocketFactoryProviderImpl(GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager) {
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
    }

    @Override
    @Nullable
    public SocketFactory createProxySocketFactoryForNonSsh(String forcedTargetHostname, Integer forcedTargetPort) throws IOException {
        if (!this.proxyPreferencesManager.isProxyEnabledForJfed()) {
            return null;
        }
        return this.createSshProxySocketFactory(forcedTargetHostname, forcedTargetPort, this.proxyPreferencesManager.isDnsOverProxyRequiredForJFed());
    }

    @Override
    @Nullable
    public SocketFactory createProxySocketFactoryForSsh(String forcedTargetHostname, Integer forcedTargetPort) throws IOException {
        if (!this.proxyPreferencesManager.isProxyEnabledForSsh()) {
            return null;
        }
        return this.createSshProxySocketFactory(forcedTargetHostname, forcedTargetPort, this.proxyPreferencesManager.isDnsOverProxyRequiredForSsh());
    }

    private SocketFactory createSshProxySocketFactory(String forcedTargetHostname, Integer forcedTargetPort, boolean forceDnsOverSsh) throws IOException {
        GeniUser loggedInGeniUser = this.geniUserProvider.getLoggedInGeniUser();
        assert (loggedInGeniUser.getUserAuthorityServer() != null);
        GeniUserSshKeyInfo sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)loggedInGeniUser);
        JFedConnection.SshProxyInfo proxyInfo = this.proxyPreferencesManager.chooseUserProxy(loggedInGeniUser.getUserAuthorityServer().getTestbed().getProxies(), loggedInGeniUser, (SshKeyInfo)sshKeyInfo);
        if (forceDnsOverSsh && forcedTargetHostname != null && forcedTargetPort != null) {
            return SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)proxyInfo, (String)forcedTargetHostname, (int)forcedTargetPort);
        }
        return SshProxySocketFactory.create((JFedConnection.SshProxyInfo)proxyInfo);
    }
}

