/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log_cache;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsProtos;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.protobuf.GeneratedMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiCallDetailsCache {
    private static final Logger LOG = LoggerFactory.getLogger(ApiCallDetailsCache.class);
    private final LoadingCache<ApiCallDetailsRef, SerializableApiCallDetails> callsCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).weakValues().build((CacheLoader)new CacheLoader<ApiCallDetailsRef, SerializableApiCallDetails>(){

        public SerializableApiCallDetails load(@Nonnull ApiCallDetailsRef apiCallDetailsRef) throws Exception {
            return ApiCallDetailsCache.this.getFullApiDetails(apiCallDetailsRef);
        }
    });
    private static long LARGE_DATA_LEN = 100000L;
    protected static long LARGE_FILE_SIZE = 250000L;

    protected ApiCallDetailsCache() {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected static SerializableApiCallDetails decompressFullApiDetails(@Nonnull byte[] compressedDetails) throws IOException {
        assert (compressedDetails != null);
        assert (AutoCloseable.class.isAssignableFrom(ByteArrayInputStream.class));
        assert (AutoCloseable.class.isAssignableFrom(InflaterInputStream.class));
        try (ByteArrayInputStream bais = new ByteArrayInputStream(compressedDetails);){
            SerializableApiCallDetails serializableApiCallDetails;
            try (InflaterInputStream dflIn = new InflaterInputStream(bais);){
                SerializableApiCallDetails details;
                ApiCallDetailsProtos.PBApiCallDetails pbDetails = ApiCallDetailsProtos.PBApiCallDetails.parseFrom(dflIn);
                JFedConnection.SshProxyInfo proxyInfo = null;
                if (pbDetails.hasProxyInfo()) {
                    ApiCallDetailsProtos.PBProxyInfo pbProxyInfo = pbDetails.getProxyInfo();
                    switch (pbProxyInfo.getType()) {
                        case SSH: {
                            proxyInfo = new JFedConnection.SshProxyInfo(pbProxyInfo.getHostname(), pbProxyInfo.getPort(), (String)pbProxyInfo.getExtension(ApiCallDetailsProtos.PBSshProxyInfo.username), null, (String)pbProxyInfo.getExtension(ApiCallDetailsProtos.PBSshProxyInfo.hostkey));
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported proxy type: " + String.valueOf((Object)pbProxyInfo.getType()));
                        }
                    }
                }
                serializableApiCallDetails = details = new SerializableApiCallDetails(pbDetails.getId(), pbDetails.getAuthorityName(), pbDetails.getAuthorityUrn(), pbDetails.getBaseServerUrl(), pbDetails.getCallServerUrl(), (JFedConnection.ProxyInfo)proxyInfo, pbDetails.getConnectionSslAuthUserUrn(), pbDetails.getConnectionBasicHttpAuthUsername(), pbDetails.getConnectionId(), pbDetails.getConnectionSslAuthUserCertificates(), pbDetails.getConnectionAuthenticationMethod(), pbDetails.getConnectionProtocol(), pbDetails.getConnectionType(), pbDetails.getHttpRequestLine(), pbDetails.getHttpRequestHeaders(), pbDetails.getHttpRequest(), pbDetails.getHttpStatusLine(), pbDetails.getHttpResponseHeaders(), pbDetails.getHttpReply(), pbDetails.getApiName(), pbDetails.getJavaMethodName(), pbDetails.getGeniMethodName(), pbDetails.getXmlRpcRequestJsonString(), pbDetails.getXmlRpcReplyJsonString(), pbDetails.getXmlRpcGeniValue(), pbDetails.getXmlRpcGeniOutput(), pbDetails.getXmlRpcGeniCode(), pbDetails.hasGeniResponseCode() ? Integer.valueOf(pbDetails.getGeniResponseCode()) : null, pbDetails.getGeniResponseCodeDescription(), pbDetails.hasGeniCodeIsSuccess() ? Boolean.valueOf(pbDetails.getGeniCodeIsSuccess()) : null, pbDetails.getGeniResponseOutput(), new Date(pbDetails.getStartTime()), new Date(pbDetails.getStopTime()), pbDetails.getProtogeniSpewLogUrl(), pbDetails.hasExceptionString() ? pbDetails.getExceptionString() : null);
            }
            return serializableApiCallDetails;
        }
        catch (AssertionError | Exception t) {
            LOG.warn("Received throwable while reading compressed ApiCallDetails", (Throwable)t);
            throw t;
        }
    }

    private static void discardHelper(Supplier<String> getter, Consumer<String> setter) {
        String s = getter.get();
        if (s != null && (long)s.length() > LARGE_DATA_LEN) {
            setter.accept("<REMOVED because too large (" + s.length() + " chars)>");
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    protected static byte[] compressFullApiDetails(@Nonnull SerializableApiCallDetails apiCallDetails, boolean discardLargeData) {
        ApiCallDetailsProtos.PBApiCallDetails.Builder builder = ApiCallDetailsProtos.PBApiCallDetails.newBuilder();
        builder.setId(apiCallDetails.getId());
        if (apiCallDetails.getAuthorityName() != null) {
            builder.setAuthorityName(apiCallDetails.getAuthorityName());
        }
        if (apiCallDetails.getAuthorityUrn() != null) {
            builder.setAuthorityUrn(apiCallDetails.getAuthorityUrn());
        }
        if (apiCallDetails.getBaseServerUrl() != null) {
            builder.setBaseServerUrl(apiCallDetails.getBaseServerUrl());
        }
        if (apiCallDetails.getCallServerUrl() != null) {
            builder.setCallServerUrl(apiCallDetails.getCallServerUrl());
        }
        if (apiCallDetails.getConnectionAuthenticationMethod() != null) {
            builder.setConnectionAuthenticationMethod(apiCallDetails.getConnectionAuthenticationMethod());
        }
        if (apiCallDetails.getConnectionProtocol() != null) {
            builder.setConnectionProtocol(apiCallDetails.getConnectionProtocol());
        }
        if (apiCallDetails.getConnectionType() != null) {
            builder.setConnectionType(apiCallDetails.getConnectionType());
        }
        if (apiCallDetails.getProxyInfo() != null) {
            ApiCallDetailsProtos.PBProxyInfo.Builder piBuilder = ApiCallDetailsProtos.PBProxyInfo.newBuilder();
            piBuilder.setType(apiCallDetails.getProxyInfo() instanceof JFedConnection.SshProxyInfo ? ApiCallDetailsProtos.PBProxyInfo.Type.SSH : ApiCallDetailsProtos.PBProxyInfo.Type.Base);
            piBuilder.setHostname(apiCallDetails.getProxyInfo().getHostname()).setPort(apiCallDetails.getProxyInfo().getPort());
            if (apiCallDetails.getProxyInfo() instanceof JFedConnection.SshProxyInfo) {
                JFedConnection.SshProxyInfo sshProxyInfo = (JFedConnection.SshProxyInfo)apiCallDetails.getProxyInfo();
                piBuilder.setExtension((GeneratedMessage.GeneratedExtension)ApiCallDetailsProtos.PBSshProxyInfo.username, sshProxyInfo.getUsername());
                piBuilder.setExtension((GeneratedMessage.GeneratedExtension)ApiCallDetailsProtos.PBSshProxyInfo.hostkey, sshProxyInfo.getHostKey());
            }
            builder.setProxyInfo(piBuilder);
        }
        if (apiCallDetails.getConnectionSslAuthUserUrn() != null) {
            builder.setConnectionSslAuthUserUrn(apiCallDetails.getConnectionSslAuthUserUrn());
        }
        if (apiCallDetails.getConnectionBasicHttpAuthUsername() != null) {
            builder.setConnectionBasicHttpAuthUsername(apiCallDetails.getConnectionBasicHttpAuthUsername());
        }
        if (apiCallDetails.getConnectionId() != null) {
            builder.setConnectionId(apiCallDetails.getConnectionId());
        }
        if (apiCallDetails.getConnectionSslAuthUserCertificates() != null) {
            builder.setConnectionSslAuthUserCertificates(apiCallDetails.getConnectionSslAuthUserCertificates());
        }
        if (apiCallDetails.getHttpRequestStatusLine() != null) {
            builder.setHttpRequestLine(apiCallDetails.getHttpRequestStatusLine());
        }
        if (apiCallDetails.getHttpRequestHeaders() != null) {
            builder.setHttpRequestHeaders(apiCallDetails.getHttpRequestHeaders());
        }
        if (apiCallDetails.getHttpRequest() != null) {
            builder.setHttpRequest(apiCallDetails.getHttpRequest());
        }
        if (apiCallDetails.getHttpResponseStatusLine() != null) {
            builder.setHttpStatusLine(apiCallDetails.getHttpResponseStatusLine());
        }
        if (apiCallDetails.getHttpResponseHeaders() != null) {
            builder.setHttpResponseHeaders(apiCallDetails.getHttpResponseHeaders());
        }
        if (apiCallDetails.getHttpResponse() != null) {
            builder.setHttpReply(apiCallDetails.getHttpResponse());
        }
        if (apiCallDetails.getXmlRpcRequestJsonString() != null) {
            builder.setXmlRpcRequestJsonString(apiCallDetails.getXmlRpcRequestJsonString());
        }
        if (apiCallDetails.getXmlRpcResponseJsonString() != null) {
            builder.setXmlRpcReplyJsonString(apiCallDetails.getXmlRpcResponseJsonString());
        }
        if (apiCallDetails.getApiName() != null) {
            builder.setApiName(apiCallDetails.getApiName());
        }
        if (apiCallDetails.getJavaMethodName() != null) {
            builder.setJavaMethodName(apiCallDetails.getJavaMethodName());
        }
        if (apiCallDetails.getGeniMethodName() != null) {
            builder.setGeniMethodName(apiCallDetails.getGeniMethodName());
        }
        if (apiCallDetails.getXmlRpcGeniResponseValue() != null) {
            builder.setXmlRpcGeniValue(apiCallDetails.getXmlRpcGeniResponseValue());
        }
        if (apiCallDetails.getXmlRpcGeniResponseOutput() != null) {
            builder.setXmlRpcGeniOutput(apiCallDetails.getXmlRpcGeniResponseOutput());
        }
        if (apiCallDetails.getXmlRpcGeniResponseCode() != null) {
            builder.setXmlRpcGeniCode(apiCallDetails.getXmlRpcGeniResponseCode());
        }
        if (apiCallDetails.getGeniResponseCodeIsSuccess() != null) {
            builder.setGeniCodeIsSuccess(apiCallDetails.getGeniResponseCodeIsSuccess());
        }
        if (apiCallDetails.getGeniResponseCode() != null) {
            builder.setGeniResponseCode(apiCallDetails.getGeniResponseCode());
        }
        if (apiCallDetails.getGeniResponseOutput() != null) {
            builder.setGeniResponseOutput(apiCallDetails.getGeniResponseOutput());
        }
        if (apiCallDetails.getGeniResponseCodeDescription() != null) {
            builder.setGeniResponseCodeDescription(apiCallDetails.getGeniResponseCodeDescription());
        }
        if (apiCallDetails.getStartTime() != null) {
            builder.setStartTime(apiCallDetails.getStartTime().getTime());
        }
        if (apiCallDetails.getStopTime() != null) {
            builder.setStopTime(apiCallDetails.getStopTime().getTime());
        }
        if (apiCallDetails.getProtogeniSpewLogUrl() != null) {
            builder.setProtogeniSpewLogUrl(apiCallDetails.getProtogeniSpewLogUrl());
        }
        if (apiCallDetails.getExceptionString() != null) {
            builder.setExceptionString(apiCallDetails.getExceptionString());
        }
        assert (AutoCloseable.class.isAssignableFrom(ByteArrayOutputStream.class));
        assert (AutoCloseable.class.isAssignableFrom(DeflaterOutputStream.class));
        if (discardLargeData) {
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getGeniResponseOutput(), builder::setGeniResponseOutput);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getXmlRpcGeniResponseOutput(), builder::setXmlRpcGeniOutput);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getXmlRpcGeniResponseValue(), builder::setXmlRpcGeniValue);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getXmlRpcRequestJsonString(), builder::setXmlRpcRequestJsonString);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getXmlRpcResponseJsonString(), builder::setXmlRpcReplyJsonString);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getHttpResponse(), builder::setHttpReply);
            ApiCallDetailsCache.discardHelper(() -> ((SerializableApiCallDetails)apiCallDetails).getHttpRequest(), builder::setHttpRequest);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DeflaterOutputStream dflOut = new DeflaterOutputStream(baos);){
                builder.build().writeTo(dflOut);
                dflOut.flush();
                dflOut.close();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            LOG.error("Received error while serializing ApiCallDetails", (Throwable)e);
            throw new RuntimeException("Error while serializing ApiCallDetails", e);
        }
    }

    public abstract ApiCallDetailsRef registerApiCallDetails(ApiCallDetails var1);

    public abstract ApiCallDetailsRef registerApiCallDetails(SerializableApiCallDetails var1);

    @Nullable
    public SerializableApiCallDetails getApiCallDetails(ApiCallDetailsRef apiCallDetailsRef) {
        try {
            return (SerializableApiCallDetails)this.callsCache.getUnchecked((Object)apiCallDetailsRef);
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            LOG.error("Failed to load ApiCallDetailsRef with id " + apiCallDetailsRef.getId() + " from cache. Falling back to returning null.", (Throwable)e);
            return null;
        }
    }

    protected abstract SerializableApiCallDetails getFullApiDetails(ApiCallDetailsRef var1);

    public abstract void clear();
}

