/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log_cache;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ApiCallIdGenerator;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.util.library.JFedUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class DiskApiCallDetailsCache
extends ApiCallDetailsCache {
    private static final Logger LOG = LoggerFactory.getLogger(DiskApiCallDetailsCache.class);
    private static final Marker CLEAR_MARKER = MarkerFactory.getMarker((String)"CLEAR");
    private static final Marker LOAD_MARKER = MarkerFactory.getMarker((String)"LOAD");
    private static final Marker REDUCE_MARKER = MarkerFactory.getMarker((String)"REDUCE");
    private static final Marker FLUSH_MARKER = MarkerFactory.getMarker((String)"REDUCE");
    private final Path callDir;
    private final SerializableApiCallDetailsFactory serializableApiCallDetailsFactory;

    @Inject
    DiskApiCallDetailsCache(SerializableApiCallDetailsFactory serializableApiCallDetailsFactory) {
        Path callDir;
        this.serializableApiCallDetailsFactory = serializableApiCallDetailsFactory;
        try {
            callDir = JFedUtils.getUserDataDirectoryPath().resolve("jFedCalls");
            if (!Files.exists(callDir, new LinkOption[0])) {
                Files.createDirectory(callDir, new FileAttribute[0]);
            }
            LOG.debug("Created a tempdir for logging calls at {}", (Object)callDir);
        }
        catch (IOException e) {
            LOG.error("Could not create temporary directory to store jFed calls history!", (Throwable)e);
            callDir = null;
        }
        this.callDir = callDir;
    }

    @Override
    protected SerializableApiCallDetails getFullApiDetails(ApiCallDetailsRef ref) {
        Path path = this.callDir.resolve(Integer.toString(ref.getId()));
        try {
            byte[] compressedDetails = Files.readAllBytes(path);
            return DiskApiCallDetailsCache.decompressFullApiDetails(compressedDetails);
        }
        catch (IOException e) {
            LOG.error("Could not read ApiCallDetails with ref " + String.valueOf(ref));
            return null;
        }
    }

    @Override
    public void clear() {
        try {
            Files.walkFileTree(this.callDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    LOG.debug(CLEAR_MARKER, "Skipping {}", (Object)dir.toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    try {
                        Files.delete(file);
                        LOG.debug(CLEAR_MARKER, "Successfully deleted file {}", (Object)file.toString());
                    }
                    catch (IOException ex) {
                        LOG.warn(CLEAR_MARKER, "Could not delete file {}", (Object)file.toString());
                        throw ex;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    try {
                        Files.delete(file);
                        LOG.debug("Successfully deleted FAILING file {}", (Object)file.toString());
                    }
                    catch (IOException ex) {
                        LOG.warn("Could not delete FAILING file {}", (Object)file.toString());
                        throw ex;
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("An error occurred while clearing the calls cache", (Throwable)e);
        }
    }

    @Override
    public ApiCallDetailsRef registerApiCallDetails(ApiCallDetails apiCallDetails) {
        ApiCallDetailsRef ref = new ApiCallDetailsRef(apiCallDetails);
        Path path = this.callDir.resolve(Integer.toString(ref.getId()));
        if (!path.toFile().exists()) {
            try {
                Path path2 = Files.write(path, DiskApiCallDetailsCache.compressFullApiDetails(this.serializableApiCallDetailsFactory.createFromApiCallDetails(apiCallDetails), false), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Error while writing ApiCallDetails to disk", (Throwable)e);
            }
        } else {
            LOG.debug("Detected that ApiCallDetails #{} already exists on disk. Ignoring new ApiCallDetails", (Object)apiCallDetails.getId());
        }
        return ref;
    }

    @Override
    public ApiCallDetailsRef registerApiCallDetails(SerializableApiCallDetails apiCallDetails) {
        SerializableApiCallDetails copy = new SerializableApiCallDetails(apiCallDetails);
        ApiCallDetailsRef ref = new ApiCallDetailsRef(copy);
        Path path = this.callDir.resolve(Integer.toString(ref.getId()));
        if (!path.toFile().exists()) {
            try {
                Path path2 = Files.write(path, DiskApiCallDetailsCache.compressFullApiDetails(new SerializableApiCallDetails(apiCallDetails), false), new OpenOption[0]);
            }
            catch (IOException e) {
                LOG.error("Error while writing ApiCallDetails to disk", (Throwable)e);
            }
        } else {
            LOG.debug("Detected that ApiCallDetails #{} already exists on disk. Ignoring new ApiCallDetails", (Object)apiCallDetails.getId());
        }
        return ref;
    }

    private static Integer getIdFromFile(Path file) {
        try {
            return Integer.parseInt(file.getFileName().toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public List<ApiCallDetailsRef> loadExisting() {
        final ArrayList<ApiCallDetailsRef> res = new ArrayList<ApiCallDetailsRef>();
        try {
            Files.walkFileTree(this.callDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Integer id = DiskApiCallDetailsCache.getIdFromFile(file);
                    if (id != null) {
                        res.add(new ApiCallDetailsRef(id));
                        LOG.debug(LOAD_MARKER, "Successfully loaded file {}", (Object)file.toString());
                    } else {
                        LOG.debug(LOAD_MARKER, "Not loaded: not a call file {}", (Object)file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    LOG.debug(LOAD_MARKER, "Ignoring FAILED file {}", (Object)file.toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("An error occurred while loading the calls cache", (Throwable)e);
        }
        LOG.info("Loaded previous disk call cache: " + res.size() + " calls recovered");
        return res;
    }

    private boolean isOld(Path path) {
        Integer id = DiskApiCallDetailsCache.getIdFromFile(path);
        if (id != null && Math.abs(ApiCallIdGenerator.peekId() - id) > 1000) {
            return true;
        }
        Instant daysAgo = Instant.now().minus(5L, ChronoUnit.DAYS);
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            if (attr.creationTime().toInstant().isBefore(daysAgo)) {
                return true;
            }
            if (attr.lastModifiedTime().toInstant().isBefore(daysAgo)) {
                return true;
            }
        }
        catch (IOException e) {
            LOG.error(FLUSH_MARKER, "Error while checking if " + String.valueOf(path) + " is old. Will assume it is.", (Throwable)e);
            return true;
        }
        return false;
    }

    public void flushOld() {
        try {
            Files.walkFileTree(this.callDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Integer id = DiskApiCallDetailsCache.getIdFromFile(file);
                    if (id != null && DiskApiCallDetailsCache.this.isOld(file)) {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException e) {
                            LOG.error(FLUSH_MARKER, "Failed to delete {}", (Object)file.toString());
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        LOG.error(FLUSH_MARKER, "Failed to failed delete {}", (Object)file.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("An error occurred while flusing the calls cache", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reduce(Path path) {
        Integer id = DiskApiCallDetailsCache.getIdFromFile(path);
        assert (id != null);
        SerializableApiCallDetails full = this.getFullApiDetails(new ApiCallDetailsRef(id));
        try {
            Files.write(path, DiskApiCallDetailsCache.compressFullApiDetails(full, true), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error(REDUCE_MARKER, "Failed to reduce {}", (Object)path.toString());
        }
        finally {
            full = null;
            System.gc();
        }
    }

    public void reduceOld() {
        try {
            Files.walkFileTree(this.callDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Integer id = DiskApiCallDetailsCache.getIdFromFile(file);
                    if (id != null && Files.size(file) > ApiCallDetailsCache.LARGE_FILE_SIZE) {
                        DiskApiCallDetailsCache.this.reduce(file);
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    LOG.debug(REDUCE_MARKER, "Ignoring FAILED file {}", (Object)file.toString());
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            LOG.error("An error occurred while flusing the calls cache", (Throwable)e);
        }
    }
}

