/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log_cache;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryApiCallDetailsCache
extends ApiCallDetailsCache {
    private static final Logger LOG = LoggerFactory.getLogger(MemoryApiCallDetailsCache.class);
    private final Map<ApiCallDetailsRef, byte[]> compressedApiCallDetails = new HashMap<ApiCallDetailsRef, byte[]>();
    private final SerializableApiCallDetailsFactory serializableApiCallDetailsFactory;

    @Inject
    public MemoryApiCallDetailsCache(SerializableApiCallDetailsFactory serializableApiCallDetailsFactory) {
        this.serializableApiCallDetailsFactory = serializableApiCallDetailsFactory;
    }

    @Override
    protected SerializableApiCallDetails getFullApiDetails(ApiCallDetailsRef ref) {
        try {
            return MemoryApiCallDetailsCache.decompressFullApiDetails(this.compressedApiCallDetails.get(ref));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get full API details", e);
        }
    }

    @Override
    public void clear() {
        this.compressedApiCallDetails.clear();
    }

    @Override
    public ApiCallDetailsRef registerApiCallDetails(ApiCallDetails apiCallDetails) {
        ApiCallDetailsRef ref = new ApiCallDetailsRef(apiCallDetails);
        if (!this.compressedApiCallDetails.containsKey(ref)) {
            this.compressedApiCallDetails.put(ref, MemoryApiCallDetailsCache.compressFullApiDetails(this.serializableApiCallDetailsFactory.createFromApiCallDetails(apiCallDetails), false));
        }
        return ref;
    }

    @Override
    public ApiCallDetailsRef registerApiCallDetails(SerializableApiCallDetails apiCallDetails) {
        SerializableApiCallDetails copy = new SerializableApiCallDetails(apiCallDetails);
        ApiCallDetailsRef ref = new ApiCallDetailsRef(copy);
        if (!this.compressedApiCallDetails.containsKey(ref)) {
            this.compressedApiCallDetails.put(ref, MemoryApiCallDetailsCache.compressFullApiDetails(copy, false));
        }
        return ref;
    }

    @Override
    @Nullable
    public SerializableApiCallDetails getApiCallDetails(ApiCallDetailsRef apiCallDetailsRef) {
        assert (this.compressedApiCallDetails.containsKey(apiCallDetailsRef));
        return super.getApiCallDetails(apiCallDetailsRef);
    }
}

