/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.log;

import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.log.ResultListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.inject.Singleton;
import org.slf4j.LoggerFactory;

@Singleton
public class Logger {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(Logger.class);
    protected final List<ResultListener> resultListeners = new CopyOnWriteArrayList<ResultListener>();

    public synchronized void fireResult(ApiCallDetails reply) {
        for (ResultListener l : this.resultListeners) {
            l.onResult(reply);
        }
    }

    public synchronized void addResultListener(ResultListener l) {
        this.resultListeners.add(l);
    }

    public synchronized void removeResultListener(ResultListener l) {
        this.resultListeners.remove(l);
    }

    public Logger getWrappingLogger() {
        final Logger parentLogger = this;
        return new Logger(){

            @Override
            public synchronized void fireResult(ApiCallDetails reply) {
                for (ResultListener l : parentLogger.resultListeners) {
                    l.onResult(reply);
                }
                for (ResultListener l : this.resultListeners) {
                    l.onResult(reply);
                }
            }
        };
    }

    public Logger getWrappingLogger(ResultListener l) {
        Logger res = this.getWrappingLogger();
        if (l != null) {
            res.addResultListener(l);
        }
        return res;
    }
}

