/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.Date;
import java.util.List;
import org.apache.http.StatusLine;

public class XMLRPCCallDetailsGeneral
implements XMLRPCCallDetails {
    private final String resultXmlRpcString;
    private final String requestXmlRpcString;
    private final List request;
    private final Object result;
    private final String serverUrl;
    private final ConnectionConfig connectionConfig;
    private final Date startTime;
    private final Date stopTime;
    private final Throwable exception;
    private final String requestHttpRequestLine;
    private final String requestHttpHeaders;
    private final String requestHttpContent;
    private final StatusLine resultHttpStatusLine;
    private final String resultHttpHeaders;
    private final String resultHttpContent;
    private final JFedConnection connection;

    public XMLRPCCallDetailsGeneral(ConnectionConfig connectionConfig, String serverUrl, String requestHttpRequestLine, String requestHttpHeaders, String requestHttpContent, StatusLine resultHttpStatusLine, String resultHttpHeaders, String resultHttpContent, List request, Object result, Date startTime, Date stopTime, Throwable exception, JFedConnection connection) {
        this.requestHttpRequestLine = requestHttpRequestLine;
        this.requestHttpHeaders = requestHttpHeaders;
        this.requestHttpContent = requestHttpContent;
        this.resultHttpStatusLine = resultHttpStatusLine;
        this.resultHttpHeaders = resultHttpHeaders;
        this.resultHttpContent = resultHttpContent;
        this.resultXmlRpcString = result != null ? XmlRpcPrintUtil.xmlRpcObjectToString(result) : "No result";
        this.requestXmlRpcString = XmlRpcPrintUtil.xmlRpcObjectToString(request);
        this.request = request;
        this.result = result;
        this.serverUrl = serverUrl;
        this.connectionConfig = connectionConfig;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.exception = exception;
        this.connection = connection;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    @Override
    public String getRequestHttpRequestLine() {
        return this.requestHttpRequestLine;
    }

    @Override
    public String getResultHttpHeaders() {
        return this.resultHttpHeaders;
    }

    @Override
    public String getRequestHttpContent() {
        return this.requestHttpContent;
    }

    @Override
    public int getResultHttpStatusCode() {
        return this.resultHttpStatusLine.getStatusCode();
    }

    @Override
    public String getResultHttpStatusReasonPhrase() {
        return this.resultHttpStatusLine.getReasonPhrase();
    }

    @Override
    public StatusLine getResultHttpStatusLineObject() {
        return this.resultHttpStatusLine;
    }

    @Override
    public String getRequestHttpHeaders() {
        return this.requestHttpHeaders;
    }

    @Override
    public String getResultHttpStatusLine() {
        if (this.resultHttpStatusLine == null) {
            return null;
        }
        return this.resultHttpStatusLine.toString();
    }

    @Override
    public String getResultHttpContent() {
        return this.resultHttpContent;
    }

    @Override
    public String getResultXmlRpcString() {
        return this.resultXmlRpcString;
    }

    @Override
    public String getRequestXmlRpcString() {
        return this.requestXmlRpcString;
    }

    @Override
    public List getRequest() {
        return this.request;
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public JFedConnection getLastConnection() {
        return this.connection;
    }

    @Override
    public String getResultValueString() {
        return this.result.toString();
    }

    @Override
    public Object getResultValueObject() {
        return this.result;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getStopTime() {
        return this.stopTime;
    }
}

