/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.connection;

import be.iminds.ilabt.jfed.lowlevel.connection.ConnectionConfig;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.XMLRPCCallDetails;
import be.iminds.ilabt.jfed.util.library.JSonHelper;
import be.iminds.ilabt.jfed.util.library.XmlRpcPrintUtil;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.StatusLine;

public class XMLRPCCallDetailsWithCodeValueError
implements XMLRPCCallDetails {
    private final String resultXmlRpcString;
    private final String requestXmlRpcString;
    private final List request;
    private final Map result;
    private final String serverUrl;
    private final ConnectionConfig connectionConfig;
    private final Date startTime;
    private final Date stopTime;
    private final Throwable exception;
    private final String requestHttpRequestLine;
    private final String requestHttpHeaders;
    private final String requestHttpContent;
    private final StatusLine resultHttpStatusLine;
    private final String resultHttpHeaders;
    private final String resultHttpContent;
    private final JFedConnection connection;

    public XMLRPCCallDetailsWithCodeValueError(ConnectionConfig connectionConfig, String serverUrl, String requestHttpRequestLine, String requestHttpHeaders, String requestHttpContent, StatusLine resultHttpStatusLine, String resultHttpHeaders, String resultHttpContent, List request, Map result, Date startTime, Date stopTime, Throwable exception, JFedConnection connection) {
        this.requestHttpRequestLine = requestHttpRequestLine;
        this.requestHttpHeaders = requestHttpHeaders;
        this.requestHttpContent = requestHttpContent;
        this.resultHttpStatusLine = resultHttpStatusLine;
        this.resultHttpHeaders = resultHttpHeaders;
        this.resultHttpContent = resultHttpContent;
        this.resultXmlRpcString = result != null ? XmlRpcPrintUtil.xmlRpcObjectToString(result) : "No result";
        this.requestXmlRpcString = XmlRpcPrintUtil.xmlRpcObjectToString(request);
        this.request = request;
        this.result = result;
        this.connectionConfig = connectionConfig;
        this.serverUrl = serverUrl;
        this.startTime = startTime;
        this.stopTime = stopTime;
        this.connection = connection;
        this.exception = exception;
    }

    @Override
    public String getServerUrl() {
        return this.serverUrl;
    }

    @Override
    public ConnectionConfig getConnectionConfig() {
        return this.connectionConfig;
    }

    @Override
    public String getRequestHttpContent() {
        return this.requestHttpContent;
    }

    @Override
    public String getRequestHttpHeaders() {
        return this.requestHttpHeaders;
    }

    @Override
    public int getResultHttpStatusCode() {
        return this.resultHttpStatusLine.getStatusCode();
    }

    @Override
    public String getResultHttpStatusReasonPhrase() {
        return this.resultHttpStatusLine.getReasonPhrase();
    }

    @Override
    public String getResultHttpStatusLine() {
        return this.resultHttpStatusLine.toString();
    }

    @Override
    public StatusLine getResultHttpStatusLineObject() {
        return this.resultHttpStatusLine;
    }

    @Override
    public String getRequestHttpRequestLine() {
        return this.requestHttpRequestLine;
    }

    @Override
    public String getResultHttpHeaders() {
        return this.resultHttpHeaders;
    }

    @Override
    public String getResultHttpContent() {
        return this.resultHttpContent;
    }

    @Override
    public String getResultXmlRpcString() {
        return this.resultXmlRpcString;
    }

    @Override
    public String getRequestXmlRpcString() {
        return this.requestXmlRpcString;
    }

    @Override
    public List getRequest() {
        return this.request;
    }

    @Override
    public Map getResult() {
        return this.result;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }

    @Override
    public JFedConnection getLastConnection() {
        return this.connection;
    }

    @Override
    public String getResultValueString() {
        if (this.result == null) {
            return "";
        }
        Object value = this.result.get("value");
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    @Override
    public Object getResultValueObject() {
        if (this.result == null) {
            return null;
        }
        Object value = this.result.get("value");
        return value;
    }

    public Object getResultCode() {
        if (this.result == null) {
            return null;
        }
        return this.result.get("code");
    }

    public String getResultOutput() {
        if (this.result == null) {
            return "";
        }
        String output = (String)this.result.get("output");
        return output;
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public Date getStopTime() {
        return this.stopTime;
    }

    public String toString() {
        return "XMLRPCCallDetailsWithCodeValueError{result=" + (this.result == null ? "NULL" : JSonHelper.jsonObjectToString(this.result)) + ", startTime=" + this.startTime + ", stopTime=" + this.stopTime + ", ...}";
    }
}

