/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncrypter {
    private static final Logger LOG = LoggerFactory.getLogger(FileEncrypter.class);
    private static final int AES_KEYSIZE_BIT = 128;

    @Nullable
    public static byte[] decryptData(byte[] data, PrivateKey privateKey) {
        try {
            int i;
            ByteBuffer bb = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
            int keySize = bb.getInt();
            byte[] encryptedKey = new byte[keySize];
            byte[] encryptedData = new byte[data.length - (keySize + 4)];
            assert (bb.remaining() == data.length - 4);
            bb.get(encryptedKey);
            assert (bb.remaining() == data.length - (keySize + 4));
            bb.get(encryptedData);
            Cipher pkCipher = Cipher.getInstance("RSA");
            pkCipher.init(2, privateKey);
            ByteArrayInputStream baisKey = new ByteArrayInputStream(encryptedKey);
            CipherInputStream keyIs = new CipherInputStream(baisKey, pkCipher);
            byte[] aesKey = new byte[16];
            int read = keyIs.read(aesKey);
            assert (read == aesKey.length);
            SecretKeySpec aeskeySpec = new SecretKeySpec(aesKey, "AES");
            ByteArrayInputStream bais = new ByteArrayInputStream(encryptedData);
            Cipher aesCipher = Cipher.getInstance("AES");
            aesCipher.init(2, aeskeySpec);
            CipherInputStream is = new CipherInputStream(bais, aesCipher);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((i = is.read(b)) != -1) {
                baos.write(b, 0, i);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            LOG.error("Failed to decrypt data: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static byte[] encryptData(byte[] data, PublicKey publicKey) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            kgen.init(128);
            SecretKey key = kgen.generateKey();
            byte[] aesKey = key.getEncoded();
            assert (aesKey.length == 16);
            SecretKeySpec aeskeySpec = new SecretKeySpec(aesKey, "AES");
            Cipher pkCipher = Cipher.getInstance("RSA");
            pkCipher.init(1, publicKey);
            ByteArrayOutputStream keyBaos = new ByteArrayOutputStream();
            CipherOutputStream keyCipherOutputStream = new CipherOutputStream(keyBaos, pkCipher);
            keyCipherOutputStream.write(aesKey);
            keyCipherOutputStream.close();
            byte[] encryptedKeyBytes = keyBaos.toByteArray();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] lenBytes = new byte[4];
            ByteBuffer bb = ByteBuffer.wrap(lenBytes).order(ByteOrder.BIG_ENDIAN);
            bb.clear();
            bb.putInt(encryptedKeyBytes.length);
            baos.write(lenBytes);
            baos.write(encryptedKeyBytes);
            Cipher aesCipher = Cipher.getInstance("AES");
            aesCipher.init(1, aeskeySpec);
            CipherOutputStream cipherOutputStream = new CipherOutputStream(baos, aesCipher);
            cipherOutputStream.write(data);
            cipherOutputStream.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            LOG.error("Failed to encrypt data: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decryptString(byte[] input, PrivateKey privateKey) {
        byte[] data = FileEncrypter.decryptData(input, privateKey);
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: UTF-8 not supported", e);
        }
    }

    public static byte[] encryptString(String input, PublicKey publicKey) {
        try {
            return FileEncrypter.encryptData(input.getBytes("UTF-8"), publicKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unexpected: UTF-8 not supported", e);
        }
    }
}

