/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.util.library;

import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighStrengthCipherUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HighStrengthCipherUtil.class);

    private HighStrengthCipherUtil() {
    }

    public static boolean hasHighStrengthCipher() {
        boolean test2;
        boolean test1;
        try {
            test1 = Cipher.getMaxAllowedKeyLength("RC5") >= 256;
            test2 = Cipher.getMaxAllowedKeyLength("AES") > 128;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Error checking HighStrengthCipher", (Throwable)e);
            return false;
        }
        return test1 && test2;
    }

    public static String getHighStrengthCipherDebugString() {
        Object res = "";
        try {
            res = (String)res + "RC5.len=" + Cipher.getMaxAllowedKeyLength("RC5");
            res = (String)res + " AES.len=" + Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Error checking HighStrengthCipher", (Throwable)e);
            return (String)res + " Error checking HighStrengthCipher: " + e.getMessage();
        }
        return res;
    }
}

